/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.builder;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.streaming.readers.GeoJsonReader;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.tags.OneWayTag;
import org.openstreetmap.atlas.utilities.collections.StringList;

public class GeoJsonAtlasBuilder {
    public Atlas create(Resource geoJson) {
        GeoJsonReader reader = new GeoJsonReader(geoJson);
        PackedAtlasBuilder builder = new PackedAtlasBuilder();
        ArrayList edges = new ArrayList();
        long nodeIdentifier = 0L;
        reader.forEachRemaining(item -> {
            if (item.getItem() instanceof PolyLine && !(item.getItem() instanceof Polygon)) {
                Long identifier = null;
                Set<Map.Entry<String, JsonElement>> jsonTags = item.getProperties().entrySet();
                HashMap<String, String> tags = new HashMap<String, String>();
                for (Map.Entry<String, JsonElement> entry : jsonTags) {
                    String key = entry.getKey();
                    String value = entry.getValue().getAsString();
                    if (key.contains("@id")) {
                        identifier = Long.valueOf(StringList.split(value, "/").get(1));
                        continue;
                    }
                    tags.put(key, value);
                }
                if (!tags.containsKey("highway")) {
                    return;
                }
                edges.add(new GeoJsonEdge(identifier, tags, (PolyLine)item.getItem()));
            }
        });
        HashSet<Location> locations = new HashSet<Location>();
        for (GeoJsonEdge edge : edges) {
            locations.add(edge.getPolyLine().first());
            locations.add(edge.getPolyLine().last());
        }
        for (Location location : locations) {
            builder.addNode(nodeIdentifier++, location, new HashMap<String, String>());
        }
        for (GeoJsonEdge edge : edges) {
            if (edge.getTags().containsKey("oneway") && !OneWayTag.NO.name().equalsIgnoreCase(edge.getTags().get("oneway"))) {
                String onewayTag = edge.getTags().get("oneway");
                if (OneWayTag.YES.name().equalsIgnoreCase(onewayTag) || "1".equals(onewayTag)) {
                    builder.addEdge(edge.getIdentifier(), edge.getPolyLine(), edge.getTags());
                    continue;
                }
                if (!"-1".equals(onewayTag)) continue;
                builder.addEdge(edge.getIdentifier(), edge.getPolyLine().reversed(), edge.getTags());
                continue;
            }
            builder.addEdge(edge.getIdentifier(), edge.getPolyLine(), edge.getTags());
            builder.addEdge(-edge.getIdentifier(), edge.getPolyLine().reversed(), edge.getTags());
        }
        reader = new GeoJsonReader(geoJson);
        reader.forEachRemaining(item -> {
            block12: {
                String value;
                String key;
                HashMap<String, String> tags;
                Set<Map.Entry<String, JsonElement>> jsonTags;
                Long identifier;
                if (item.getItem() instanceof Polygon) {
                    identifier = null;
                    jsonTags = item.getProperties().entrySet();
                    tags = new HashMap<String, String>();
                    for (Map.Entry<String, JsonElement> entry : jsonTags) {
                        key = entry.getKey();
                        value = entry.getValue().getAsString();
                        if (key.contains("@id")) {
                            identifier = Long.valueOf(StringList.split(value, "/").get(1));
                            continue;
                        }
                        tags.put(key, value);
                    }
                    builder.addArea(identifier, (Polygon)item.getItem(), tags);
                }
                if (item.getItem() instanceof PolyLine && !(item.getItem() instanceof Polygon)) {
                    identifier = null;
                    jsonTags = item.getProperties().entrySet();
                    tags = new HashMap();
                    for (Map.Entry<String, JsonElement> entry : jsonTags) {
                        key = entry.getKey();
                        value = entry.getValue().getAsString();
                        if (key.contains("@id")) {
                            identifier = Long.valueOf(StringList.split(value, "/").get(1));
                            continue;
                        }
                        tags.put(key, value);
                    }
                    if (tags.containsKey("highway")) {
                        return;
                    }
                    builder.addLine(identifier, (PolyLine)item.getItem(), tags);
                }
                if (item.getItem() instanceof Location) {
                    identifier = null;
                    jsonTags = item.getProperties().entrySet();
                    tags = new HashMap();
                    for (Map.Entry<String, JsonElement> entry : jsonTags) {
                        key = entry.getKey();
                        value = entry.getValue().getAsString();
                        if (key.contains("@id")) {
                            identifier = Long.valueOf(StringList.split(value, "/").get(1));
                            continue;
                        }
                        tags.put(key, value);
                    }
                    try {
                        builder.addPoint(identifier, (Location)item.getItem(), tags);
                    }
                    catch (CoreException e) {
                        if (tags.isEmpty()) break block12;
                        throw e;
                    }
                }
            }
        });
        return builder.get();
    }

    private static class GeoJsonEdge {
        private final long identifier;
        private final Map<String, String> tags;
        private final PolyLine polyLine;

        GeoJsonEdge(long identifier, Map<String, String> tags, PolyLine polyLine) {
            this.identifier = identifier;
            this.tags = tags;
            this.polyLine = polyLine;
        }

        public long getIdentifier() {
            return this.identifier;
        }

        public PolyLine getPolyLine() {
            return this.polyLine;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }
    }
}

