/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.world;

import java.util.HashMap;
import java.util.List;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.generator.world.AtlasFilePathFilter;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasCloner;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldMultiAtlasGenerator
extends Command {
    private static final Command.Switch<String> ATLAS_PATH = new Command.Switch("atlasPath", "The path to the atlas directory", value -> value, Command.Optionality.REQUIRED);
    private static final Command.Switch<String> OUTPUT_PATH = new Command.Switch("outputPath", "The path to the output world multi atlas", value -> value, Command.Optionality.REQUIRED);
    private static final Logger logger = LoggerFactory.getLogger(WorldMultiAtlasGenerator.class);

    public static void main(String[] args) {
        new WorldMultiAtlasGenerator().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        String atlasPath = (String)command.get(ATLAS_PATH);
        String outputPath = (String)command.get(OUTPUT_PATH);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("fs.file.impl", "org.apache.hadoop.fs.LocalFileSystem");
        List<Resource> atlasFiles = FileSystemHelper.listResourcesRecursively(atlasPath, configuration, new AtlasFilePathFilter());
        logger.info("Creating multiatlas from input atlases.");
        MultiAtlas multiAtlas = MultiAtlas.loadFromPackedAtlas(atlasFiles);
        PackedAtlasCloner packedAtlasCloner = new PackedAtlasCloner();
        PackedAtlas finalAtlas = packedAtlasCloner.cloneFrom(multiAtlas);
        finalAtlas.save(new File(outputPath));
        logger.info("Final atlas saved to {}", (Object)outputPath);
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(ATLAS_PATH, OUTPUT_PATH);
    }
}

