/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.sharding;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.openstreetmap.atlas.generator.sharding.OverpassOsmNode;
import org.openstreetmap.atlas.generator.sharding.OverpassOsmWay;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.streaming.resource.http.PostResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OverpassClient {
    private static final Logger logger = LoggerFactory.getLogger(OverpassClient.class);
    private static String BASE_QUERY;
    private static final String END_QUERY = ");out body;";
    private static boolean tooMuchResponseData;
    private static boolean unknownError;
    private String server = "-api.de";
    private HttpHost proxy;

    public static String buildCompactQuery(String type, Rectangle bounds) {
        return type + "(" + OverpassClient.constructBoundingBox(bounds) + ");<;";
    }

    public static String buildCompoundQuery(String type, String key, String value, Rectangle bounds) {
        return type + "[\"" + key + "\"~\"" + value + "\"](" + OverpassClient.constructBoundingBox(bounds) + END_QUERY;
    }

    public static String buildQuery(String type, Rectangle bounds) {
        return type + "(" + OverpassClient.constructBoundingBox(bounds) + END_QUERY;
    }

    public static String buildQuery(String type, String key, String value, Rectangle bounds) {
        return type + "[\"" + key + "\"=\"" + value + "\"](" + OverpassClient.constructBoundingBox(bounds) + END_QUERY;
    }

    private static void checkForErrors(Document document) {
        if (document.getDocumentElement().getElementsByTagName("remark").item(0) != null && document.getDocumentElement().getElementsByTagName("remark").item(0).getTextContent().contains("runtime error: Query ran out of memory")) {
            tooMuchResponseData = true;
        } else if (document.getDocumentElement().getElementsByTagName("remark").item(0) != null && document.getDocumentElement().getElementsByTagName("remark").item(0).getTextContent().contains("error")) {
            unknownError = true;
        }
    }

    private static String constructBoundingBox(Rectangle bounds) {
        return bounds.lowerLeft().getLatitude() + "," + bounds.upperLeft().getLongitude() + "," + bounds.upperRight().getLatitude() + "," + bounds.lowerRight().getLongitude();
    }

    public OverpassClient() {
        this.initializeBaseQuery();
    }

    public OverpassClient(String server) {
        if (server != null) {
            this.server = server;
        }
        this.initializeBaseQuery();
    }

    public OverpassClient(String server, HttpHost proxy) {
        if (server != null) {
            this.server = server;
        }
        this.proxy = proxy;
        this.initializeBaseQuery();
    }

    public CloseableHttpResponse getResponse(String specificQuery) throws UnsupportedEncodingException {
        PostResource post = new PostResource(BASE_QUERY);
        if (this.proxy != null) {
            post.setProxy(this.proxy);
        }
        post.setStringBody("data=" + URLEncoder.encode(specificQuery, "UTF-8"), ContentType.APPLICATION_FORM_URLENCODED);
        return post.getResponse();
    }

    public boolean hasTooMuchResponseData() {
        return tooMuchResponseData;
    }

    public boolean hasUnknownError() {
        return unknownError;
    }

    public List<String> nodeIdsFromWayQuery(String query) throws ParserConfigurationException, UnsupportedOperationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        try (CloseableHttpResponse response = this.getResponse(query);){
            Document doc = builder.parse(response.getEntity().getContent());
            NodeList nodelist = doc.getElementsByTagName("nd");
            ArrayList<String> nodeIds = new ArrayList<String>();
            for (int i = 0; i < nodelist.getLength(); ++i) {
                nodeIds.add(nodelist.item(i).getAttributes().item(0).getNodeValue());
            }
            ArrayList<String> arrayList = nodeIds;
            return arrayList;
        }
    }

    public List<OverpassOsmNode> nodesFromQuery(String query) throws UnsupportedOperationException, SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        try (CloseableHttpResponse response = this.getResponse(query);){
            logger.info("Parsing node query response...");
            Document document = builder.parse(response.getEntity().getContent());
            OverpassClient.checkForErrors(document);
            if (tooMuchResponseData || unknownError) {
                ArrayList<OverpassOsmNode> arrayList = new ArrayList<OverpassOsmNode>();
                return arrayList;
            }
            NodeList nodelist = document.getElementsByTagName("node");
            int nodeListLength = nodelist.getLength();
            ArrayList<OverpassOsmNode> osmNodes = new ArrayList<OverpassOsmNode>(nodeListLength);
            for (int i = 0; i < nodeListLength; ++i) {
                String osmIdentifier = nodelist.item(i).getAttributes().item(0).getNodeValue();
                String latitude = nodelist.item(i).getAttributes().item(1).getNodeValue();
                String longitude = nodelist.item(i).getAttributes().item(2).getNodeValue();
                osmNodes.add(new OverpassOsmNode(osmIdentifier, latitude, longitude));
            }
            logger.info("Parsed all nodes.");
            ArrayList<OverpassOsmNode> arrayList = osmNodes;
            return arrayList;
        }
    }

    public List<OverpassOsmWay> waysFromQuery(String query) throws ParserConfigurationException, IOException, UnsupportedOperationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        try (CloseableHttpResponse response = this.getResponse(query);){
            logger.info("Parsing way query response...");
            Document document = builder.parse(response.getEntity().getContent());
            OverpassClient.checkForErrors(document);
            if (tooMuchResponseData || unknownError) {
                ArrayList<OverpassOsmWay> arrayList = new ArrayList<OverpassOsmWay>();
                return arrayList;
            }
            NodeList wayNodeList = document.getElementsByTagName("way");
            int wayListLength = wayNodeList.getLength();
            ArrayList<OverpassOsmWay> osmWays = new ArrayList<OverpassOsmWay>(wayListLength);
            for (int i = 0; i < wayListLength; ++i) {
                Element wayElement = (Element)wayNodeList.item(i);
                String wayIdentifier = wayElement.getAttributes().item(0).getNodeValue();
                NodeList nodeNodeList = wayElement.getElementsByTagName("nd");
                int nodeListLength = nodeNodeList.getLength();
                ArrayList<String> nodeIdentifiers = new ArrayList<String>(nodeListLength);
                for (int j = 0; j < nodeListLength; ++j) {
                    nodeIdentifiers.add(nodeNodeList.item(j).getAttributes().item(0).getNodeValue());
                }
                NodeList tagNodeList = wayElement.getElementsByTagName("tag");
                int tagListLength = tagNodeList.getLength();
                HashMap<String, String> tags = new HashMap<String, String>(tagListLength);
                for (int j = 0; j < tagListLength; ++j) {
                    tags.put(tagNodeList.item(j).getAttributes().item(0).getNodeValue(), tagNodeList.item(j).getAttributes().item(1).getNodeValue());
                }
                osmWays.add(new OverpassOsmWay(wayIdentifier, nodeIdentifiers, tags));
            }
            logger.info("Parsed all ways.");
            ArrayList<OverpassOsmWay> arrayList = osmWays;
            return arrayList;
        }
    }

    private void initializeBaseQuery() {
        BASE_QUERY = "http://overpass" + this.server + "/api/interpreter/";
        logger.info("Overpass Server Queried: " + BASE_QUERY);
    }

    static {
        tooMuchResponseData = false;
        unknownError = false;
    }
}

