/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.sharding;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.spark.SparkJob;
import org.openstreetmap.atlas.generator.tools.spark.converters.ConfigurationConverter;
import org.openstreetmap.atlas.geography.sharding.DynamicTileSharding;
import org.openstreetmap.atlas.geography.sharding.GeoHashSharding;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.geography.sharding.SlippyTileSharding;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.StringList;

public final class AtlasSharding {
    private static final int SHARDING_STRING_SPLIT = 2;
    private static final int SLIPPY_ZOOM_MAXIMUM = 18;

    public static Sharding forString(String sharding, Configuration configuration) {
        StringList split = StringList.split(sharding, "@");
        if (split.size() != 2) {
            throw new CoreException("Invalid sharding string: {}", sharding);
        }
        if ("slippy".equals(split.get(0))) {
            int zoom = Integer.valueOf(split.get(1));
            if (zoom > 18) {
                throw new CoreException("Slippy Sharding zoom too high : {}, max is {}", zoom, 18);
            }
            return new SlippyTileSharding(zoom);
        }
        if ("geohash".equals(split.get(0))) {
            int precision = Integer.valueOf(split.get(1));
            return new GeoHashSharding(precision);
        }
        if ("dynamic".equals(split.get(0))) {
            Resource shardingResource = SparkJob.resource(split.get(1), ConfigurationConverter.hadoopToMapConfiguration(configuration));
            if (shardingResource == null) {
                throw new CoreException("Sharding resource does not exist: {}", sharding);
            }
            return new DynamicTileSharding(shardingResource);
        }
        throw new CoreException("Sharding type {} is not recognized.", split.get(0));
    }

    public static Sharding forString(String sharding, Map<String, String> configuration) {
        Configuration hadoopConfiguration = new Configuration();
        configuration.forEach((arg_0, arg_1) -> ((Configuration)hadoopConfiguration).set(arg_0, arg_1));
        return AtlasSharding.forString(sharding, hadoopConfiguration);
    }

    private AtlasSharding() {
    }
}

