/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.persistence;

import java.io.Writer;
import java.util.List;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.persistence.AbstractFileOutputFormat;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.streaming.resource.AbstractWritableResource;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.writers.SafeBufferedWriter;

public class FeatureChangeOutputFormat
extends AbstractFileOutputFormat<List<FeatureChange>> {
    @Override
    protected String fileExtension() {
        return FileSuffix.GEO_JSON.toString();
    }

    @Override
    protected boolean isCompressed() {
        return true;
    }

    @Override
    protected void save(List<FeatureChange> value, AbstractWritableResource out) {
        try (SafeBufferedWriter writer = out.writer();){
            for (FeatureChange featureChange : value) {
                ((Writer)writer).write(featureChange.toGeoJson());
                ((Writer)writer).write(System.lineSeparator());
            }
        }
        catch (Exception e) {
            throw new CoreException("Unable to save {}!", out.getName(), e);
        }
    }
}

