/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.exception;

import java.util.Optional;

public final class ExceptionSearch<T extends Throwable> {
    private final Class<T> target;

    public static <T extends Throwable> ExceptionSearch<T> find(Class<T> target) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        return new ExceptionSearch<T>(target);
    }

    private ExceptionSearch(Class<T> target) {
        this.target = target;
    }

    public Optional<T> within(Throwable source) {
        if (this.target == null) {
            throw new IllegalStateException("target is null");
        }
        return Optional.ofNullable(this.within0(source));
    }

    private T within0(Throwable source) {
        if (source == null) {
            return null;
        }
        if (this.target.isInstance(source)) {
            return (T)((Throwable)this.target.cast(source));
        }
        return this.within0(source.getCause());
    }
}

