/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.tuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidTagsCheck
extends BaseCheck<String> {
    private static final long serialVersionUID = 5150282147895785829L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("OSM feature {0,number,#} has invalid tags.", "Check the following tags for missing, conflicting, or incorrect values: {0}");
    private static final String KEY_VALUE_SEPARATOR = "->";
    private static final String DEFAULT_FILTER_RESOURCE = "invalidTags.txt";
    private static final Logger logger = LoggerFactory.getLogger(InvalidTagsCheck.class);
    private final List<Tuple<? extends Class<AtlasEntity>, List<TaggableFilter>>> classTagFilters;
    private final boolean overrideResourceFilters;
    private final boolean appendToResourceFilters;

    private static List<Tuple<? extends Class<AtlasEntity>, List<TaggableFilter>>> getDefaultFilters() {
        ArrayList<Tuple<? extends Class<AtlasEntity>, List<TaggableFilter>>> arrayList;
        BufferedReader reader = new BufferedReader(new InputStreamReader(InvalidTagsCheck.class.getResourceAsStream(DEFAULT_FILTER_RESOURCE)));
        try {
            String line;
            ArrayList<Tuple<? extends Class<AtlasEntity>, List<TaggableFilter>>> listOfClassToFilters = new ArrayList<Tuple<? extends Class<AtlasEntity>, List<TaggableFilter>>>();
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(":");
                if (split.length != 2) continue;
                listOfClassToFilters.add(new Tuple(ItemType.valueOf(split[0].toUpperCase()).getMemberClass(), InvalidTagsCheck.getFiltersFromResource(split[1])));
            }
            arrayList = listOfClassToFilters;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                logger.error(String.format("Could not read %s", DEFAULT_FILTER_RESOURCE), (Throwable)exception);
                return Collections.emptyList();
            }
        }
        reader.close();
        return arrayList;
    }

    private static Set<String> getFilterKeys(TaggableFilter filter) {
        return Arrays.stream(filter.toString().split("[|&]+")).filter(string -> string.contains(KEY_VALUE_SEPARATOR)).map(tag -> tag.split(KEY_VALUE_SEPARATOR)[0]).collect(Collectors.toSet());
    }

    private static List<TaggableFilter> getFiltersFromResource(String filterResourcePath) {
        List<TaggableFilter> list;
        InputStreamReader reader = new InputStreamReader(InvalidTagsCheck.class.getResourceAsStream(filterResourcePath));
        try {
            JsonElement element = new JsonParser().parse(reader);
            JsonArray filters = element.getAsJsonObject().get("filters").getAsJsonArray();
            list = StreamSupport.stream(filters.spliterator(), false).map(jsonElement -> TaggableFilter.forDefinition(jsonElement.getAsString())).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                logger.error("There was a problem parsing invalid-tags-check-filter.json. Check if the JSON file has valid structure.", (Throwable)exception);
                return Collections.emptyList();
            }
        }
        reader.close();
        return list;
    }

    private static Tuple<? extends Class<AtlasEntity>, List<TaggableFilter>> stringsToClassTagFilter(String classString, String tagFilterString) {
        ArrayList<TaggableFilter> filters = new ArrayList<TaggableFilter>();
        filters.add(TaggableFilter.forDefinition(tagFilterString));
        return new Tuple(ItemType.valueOf(classString.toUpperCase()).getMemberClass(), filters);
    }

    public InvalidTagsCheck(Configuration configuration) {
        super(configuration);
        this.overrideResourceFilters = this.configurationValue(configuration, "filters.resource.override", false);
        this.appendToResourceFilters = this.configurationValue(configuration, "filters.resource.append", false);
        if (this.overrideResourceFilters && !this.appendToResourceFilters) {
            this.classTagFilters = this.getFiltersFromConfiguration(configuration);
        } else if (!this.overrideResourceFilters && this.appendToResourceFilters) {
            List<Tuple<? extends Class<AtlasEntity>, List<TaggableFilter>>> defaultFilters = InvalidTagsCheck.getDefaultFilters();
            defaultFilters.addAll(this.getFiltersFromConfiguration(configuration));
            this.classTagFilters = defaultFilters;
        } else {
            this.classTagFilters = Collections.emptyList();
        }
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !this.isFlagged(this.getUniqueOSMIdentifier(object));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        List<String> instructions = this.classTagFilters.stream().filter(classTagFilter -> ((Class)classTagFilter.getFirst()).isInstance(object)).map(Tuple::getSecond).flatMap(Collection::stream).filter(filter -> filter.test(object)).map(taggableFilter -> this.getLocalizedInstruction(1, InvalidTagsCheck.getFilterKeys(taggableFilter))).collect(Collectors.toList());
        if (!instructions.isEmpty()) {
            this.markAsFlagged(this.getUniqueOSMIdentifier(object));
            String instruction = this.getLocalizedInstruction(0, object.getOsmIdentifier());
            CheckFlag flag = object instanceof Edge ? this.createFlag(new OsmWayWalker((Edge)object).collectEdges(), instruction) : this.createFlag(object, instruction);
            instructions.forEach(flag::addInstruction);
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private List<Tuple<? extends Class<AtlasEntity>, List<TaggableFilter>>> getFiltersFromConfiguration(Configuration configuration) {
        return this.configurationValue(configuration, "filters.classes.tags", Collections.emptyList(), configList -> configList.stream().map(classTagValue -> {
            List classTagList = (List)classTagValue;
            if (classTagList.size() > 1) {
                return Optional.of(InvalidTagsCheck.stringsToClassTagFilter((String)classTagList.get(0), (String)classTagList.get(1)));
            }
            return Optional.empty();
        }).filter(Optional::isPresent).map(tuple -> (Tuple)tuple.get()).collect(Collectors.toList()));
    }
}

