/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.tags.AreaTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LandUseTag;
import org.openstreetmap.atlas.tags.ManMadeTag;
import org.openstreetmap.atlas.tags.NaturalTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class ConflictingAreaTagCombination
extends BaseCheck {
    private static final String INVALID_COMBINATION_INSTRUCTION = "OSM feature {0,number,#} has invalid tag combinations.";
    private static final String INVALID_BUILDING_NATURAL_INSTRUCTION = "Building tag should not exist with natural tag";
    private static final String INVALID_BUILDING_HIGHWAY_INSTRUCTION = "Building tag should not exist with highway tag";
    private static final String INVALID_NATURAL_HIGHWAY_INSTRUCTION = "Natural tag should not exist with highway tag";
    private static final String INVALID_WATER_LANDUSE_INSTRUCTION = "natural=WATER tag should not exist with any landuse tag other than RESERVOIR, BASIN, or AQUACULTURE";
    private static final String INVALID_WATER_MANMADE_INSTRUCTION = "natural=WATER tag should not exist with any MAN_MADE tag other than RESERVOIR_COVERED or WASTEWATER_PLANT";
    private static final String INVALID_LANDUSE_HIGHWAY = "Land use tag should not exist with highway tag";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("OSM feature {0,number,#} has invalid tag combinations.", "Building tag should not exist with natural tag", "Building tag should not exist with highway tag", "Natural tag should not exist with highway tag", "natural=WATER tag should not exist with any MAN_MADE tag other than RESERVOIR_COVERED or WASTEWATER_PLANT", "natural=WATER tag should not exist with any landuse tag other than RESERVOIR, BASIN, or AQUACULTURE", "Land use tag should not exist with highway tag");
    private static final Predicate<Taggable> BUILDING_NATURAL = object -> Validators.isNotOfType((Taggable)object, BuildingTag.class, (Enum[])new BuildingTag[]{BuildingTag.NO}) && Validators.hasValuesFor(object, NaturalTag.class);
    private static final Predicate<Taggable> BUILDING_HIGHWAY = object -> Validators.isNotOfType((Taggable)object, BuildingTag.class, (Enum[])new BuildingTag[]{BuildingTag.NO}) && Validators.isNotOfType((Taggable)object, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.SERVICES});
    private static final Predicate<Taggable> NATURAL_HIGHWAY = object -> Validators.hasValuesFor(object, NaturalTag.class) && Validators.hasValuesFor(object, HighwayTag.class);
    private static final Predicate<Taggable> NATURAL_WATER_MANMANDE = object -> Validators.isOfType((Taggable)object, NaturalTag.class, (Enum[])new NaturalTag[]{NaturalTag.WATER}) && Validators.isNotOfType((Taggable)object, ManMadeTag.class, (Enum[])new ManMadeTag[]{ManMadeTag.RESERVOIR_COVERED, ManMadeTag.WASTEWATER_PLANT});
    private static final Predicate<Taggable> WATER_LANDUSE = object -> Validators.isOfType((Taggable)object, NaturalTag.class, (Enum[])new NaturalTag[]{NaturalTag.WATER}) && Validators.isNotOfType((Taggable)object, LandUseTag.class, (Enum[])new LandUseTag[]{LandUseTag.RESERVOIR, LandUseTag.BASIN, LandUseTag.AQUACULTURE});
    private static final Predicate<Taggable> LANDUSE_HIGHWAY = object -> Validators.hasValuesFor(object, LandUseTag.class) && Validators.hasValuesFor(object, HighwayTag.class);
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int FIVE = 5;
    private static final int SIX = 6;
    private static final long serialVersionUID = 9167816371258788999L;

    public ConflictingAreaTagCombination(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Area && !Validators.isOfType((Taggable)object, AreaTag.class, (Enum[])new AreaTag[]{AreaTag.NO});
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        CheckFlag flag = this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier()));
        boolean hasConflictingCombinations = false;
        if (BUILDING_NATURAL.test(object)) {
            flag.addInstruction(this.getLocalizedInstruction(1, new Object[0]));
            hasConflictingCombinations = true;
        }
        if (BUILDING_HIGHWAY.test(object)) {
            flag.addInstruction(this.getLocalizedInstruction(2, new Object[0]));
            hasConflictingCombinations = true;
        }
        if (NATURAL_HIGHWAY.test(object)) {
            flag.addInstruction(this.getLocalizedInstruction(3, new Object[0]));
            hasConflictingCombinations = true;
        }
        if (NATURAL_WATER_MANMANDE.test(object)) {
            flag.addInstruction(this.getLocalizedInstruction(4, new Object[0]));
            hasConflictingCombinations = true;
        }
        if (WATER_LANDUSE.test(object)) {
            flag.addInstruction(this.getLocalizedInstruction(5, new Object[0]));
            hasConflictingCombinations = true;
        }
        if (LANDUSE_HIGHWAY.test(object)) {
            flag.addInstruction(this.getLocalizedInstruction(6, new Object[0]));
            hasConflictingCombinations = true;
        }
        if (hasConflictingCombinations) {
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

