/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.points;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.tags.AddressStreetTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class AddressStreetNameCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 5401402333350044455L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Address node {0,number,#} has an addr:street value that does not match the name of any roads within {1,number,#} meters.");
    private static final Double SEARCH_DISTANCE_DEFAULT = 100.0;
    private final Distance searchDistance;

    public AddressStreetNameCheck(Configuration configuration) {
        super(configuration);
        this.searchDistance = this.configurationValue(configuration, "bounds.size", SEARCH_DISTANCE_DEFAULT, Distance::meters);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Point && Validators.hasValuesFor(object, AddressStreetTag.class);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Set streetNameValues = Iterables.stream(object.getAtlas().edgesIntersecting(((Point)object).getLocation().boxAround(this.searchDistance), Edge::isMasterEdge)).flatMap(edge -> edge.getTags(tag -> tag.startsWith("name")).values()).collectToSet();
        return !streetNameValues.isEmpty() && !streetNameValues.contains(object.tag("addr:street")) ? Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier(), this.searchDistance.asMeters()))) : Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

