/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.checks.atlas.predicates.TagPredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.AccessTag;
import org.openstreetmap.atlas.tags.AerowayTag;
import org.openstreetmap.atlas.tags.AmenityTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.MotorVehicleTag;
import org.openstreetmap.atlas.tags.MotorcarTag;
import org.openstreetmap.atlas.tags.RouteTag;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.VehicleTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class SinkIslandCheck
extends BaseCheck<Long> {
    private static final AmenityTag[] AMENITY_VALUES_TO_EXCLUDE = new AmenityTag[]{AmenityTag.PARKING, AmenityTag.PARKING_SPACE, AmenityTag.MOTORCYCLE_PARKING, AmenityTag.PARKING_ENTRANCE};
    private static final String DEFAULT_MINIMUM_HIGHWAY_TYPE = "SERVICE";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Road is impossible to get out of.");
    private static final float LOAD_FACTOR = 0.8f;
    private static final Predicate<AtlasObject> NAVIGABLE_HIGHWAYS = object -> Validators.isOfType((Taggable)object, MotorVehicleTag.class, (Enum[])new MotorVehicleTag[]{MotorVehicleTag.YES, MotorVehicleTag.DESIGNATED, MotorVehicleTag.PERMISSIVE}) || Validators.isOfType((Taggable)object, MotorcarTag.class, (Enum[])new MotorcarTag[]{MotorcarTag.YES, MotorcarTag.DESIGNATED, MotorcarTag.PERMISSIVE}) || Validators.isOfType((Taggable)object, VehicleTag.class, (Enum[])new VehicleTag[]{VehicleTag.YES, VehicleTag.DESIGNATED, VehicleTag.PERMISSIVE});
    private static final Predicate<AtlasObject> SERVICE_ROAD = object -> Validators.isOfType((Taggable)object, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.SERVICE});
    private static final Predicate<AtlasObject> IS_AT_LEAST_SERVICE_ROAD = object -> ((Edge)object).highwayTag().isMoreImportantThanOrEqualTo(HighwayTag.SERVICE);
    private static final long TREE_SIZE_DEFAULT = 50L;
    private static final boolean DEFAULT_SERVICE_IN_PEDESTRIAN_FILTER = false;
    private static final long serialVersionUID = -1432150496331502258L;
    private final HighwayTag minimumHighwayType;
    private final int storeSize;
    private final int treeSize;
    private final boolean serviceInPedestrianNetworkFilter;

    public SinkIslandCheck(Configuration configuration) {
        super(configuration);
        this.treeSize = this.configurationValue(configuration, "tree.size", 50L, Math::toIntExact);
        this.minimumHighwayType = this.configurationValue(configuration, "minimum.highway.type", DEFAULT_MINIMUM_HIGHWAY_TYPE, string -> HighwayTag.valueOf(string.toUpperCase()));
        this.storeSize = (int)((float)this.treeSize / 0.8f);
        this.serviceInPedestrianNetworkFilter = this.configurationValue(configuration, "filter.pedestrian.network", false);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return this.validEdge(object) && !this.isFlagged(object.getIdentifier()) && ((Edge)object).highwayTag().isMoreImportantThanOrEqualTo(this.minimumHighwayType) && (!SERVICE_ROAD.test(object) || !this.isWithinAreasWithExcludedAmenityTags((Edge)object) && !this.intersectsAirportOrBuilding((Edge)object));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        boolean haltedSearch = false;
        Edge candidate = (Edge)object;
        HashSet<Edge> explored = new HashSet<Edge>(this.storeSize, 0.8f);
        HashSet<Edge> terminal = new HashSet<Edge>();
        ArrayDeque candidates = new ArrayDeque(this.storeSize);
        explored.add(candidate);
        while (candidate != null) {
            if (this.edgeCharacteristicsToIgnore(candidate)) {
                haltedSearch = true;
                explored.add(candidate);
                break;
            }
            List outEdges = candidate.outEdges().stream().filter(this::validEdge).distinct().sorted().collect(Collectors.toList());
            if (candidate.getTag("motor_vehicle").orElse(MotorVehicleTag.NO.name()).equals(MotorVehicleTag.YES.name())) {
                outEdges.addAll(candidate.outEdges().stream().filter(HighwayTag::isPedestrianNavigableHighway).distinct().sorted().collect(Collectors.toList()));
            }
            if (outEdges.isEmpty()) {
                terminal.add(candidate);
            } else {
                explored.add(candidate);
                outEdges.stream().filter(this::validEdge).filter(outEdge -> !explored.contains(outEdge)).forEach(candidates::add);
                if (candidates.size() + explored.size() > this.treeSize) {
                    haltedSearch = true;
                    break;
                }
            }
            candidate = (Edge)candidates.poll();
        }
        explored.addAll(terminal);
        explored.forEach(marked -> this.markAsFlagged(marked.getIdentifier()));
        if (!haltedSearch) {
            return Optional.of(this.createFlag(explored, this.getLocalizedInstruction(0, new Object[0])));
        }
        if (!terminal.isEmpty()) {
            return Optional.of(this.createFlag(terminal, this.getLocalizedInstruction(0, new Object[0])));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean edgeCharacteristicsToIgnore(Edge edge) {
        return this.isFlagged(edge.getIdentifier()) || this.endOrStartNodeHasAmenityTypeToExclude(edge) || SyntheticBoundaryNodeTag.isBoundaryNode(edge.end()) || SyntheticBoundaryNodeTag.isBoundaryNode(edge.start()) || !this.serviceInPedestrianNetworkFilter && IS_AT_LEAST_SERVICE_ROAD.test(edge) && this.isConnectedToPedestrianNavigableHighway(edge) || SERVICE_ROAD.test(edge) && this.intersectsAirportOrBuilding(edge);
    }

    private boolean endOrStartNodeHasAmenityTypeToExclude(AtlasObject object) {
        Edge edge = (Edge)object;
        return Validators.isOfType((Taggable)edge.end(), AmenityTag.class, (Enum[])AMENITY_VALUES_TO_EXCLUDE) || Validators.isOfType((Taggable)edge.start(), AmenityTag.class, (Enum[])new AmenityTag[]{AmenityTag.PARKING_ENTRANCE});
    }

    private boolean intersectsAirportOrBuilding(Edge edge) {
        return StreamSupport.stream(edge.getAtlas().areasIntersecting(edge.bounds(), area -> Validators.hasValuesFor(area, AmenityTag.class) || BuildingTag.isBuilding(area) || Validators.hasValuesFor(area, AerowayTag.class)).spliterator(), false).anyMatch(area -> area.asPolygon().overlaps(edge.asPolyLine()));
    }

    private boolean isAccessible(Edge edge) {
        return !Validators.hasValuesFor(edge, AccessTag.class) || !AccessTag.isPrivate(edge);
    }

    private boolean isConnectedToPedestrianNavigableHighway(Edge edge) {
        return edge.connectedEdges().stream().anyMatch(HighwayTag::isPedestrianNavigableHighway);
    }

    private boolean isNavigable(Edge edge) {
        return !Validators.hasValuesFor(edge, MotorVehicleTag.class) && !Validators.hasValuesFor(edge, MotorcarTag.class) && !Validators.hasValuesFor(edge, VehicleTag.class) || NAVIGABLE_HIGHWAYS.test(edge);
    }

    private boolean isWithinAreasWithExcludedAmenityTags(Edge edge) {
        return StreamSupport.stream(edge.getAtlas().areasIntersecting(edge.bounds(), area -> Validators.isOfType((Taggable)area, AmenityTag.class, (Enum[])AMENITY_VALUES_TO_EXCLUDE)).spliterator(), false).anyMatch(area -> area.asPolygon().fullyGeometricallyEncloses(edge.asPolyLine()));
    }

    private boolean validEdge(AtlasObject object) {
        return object instanceof Edge && HighwayTag.isCarNavigableHighway(object) && this.isAccessible((Edge)object) && this.isNavigable((Edge)object) && !RouteTag.isFerry(object) && !TagPredicates.IS_AREA.test(object);
    }
}

