/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.BarrierTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class ShortSegmentCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This edge {0,number,#} is short (length < {1} m) and it is connected to node {2,number,#} that has less than {3} connections.");
    private static final double MAXIMUM_LENGTH_DEFAULT = Distance.ONE_METER.asMeters();
    private static final long MINIMUM_VALENCE_DEFAULT = 3L;
    private static final String MINIMUM_HIGHWAY_PRIORITY_DEFAULT = HighwayTag.SERVICE.toString();
    private static final long serialVersionUID = 6916628316458828018L;
    private final Distance maximumLength;
    private final long minimumValence;
    private final HighwayTag minimumHighwayPriority;

    private static Optional<Node> getConnectedNodesWithValenceLessThan(Edge edge, long valence) {
        for (Node node : edge.connectedNodes()) {
            List masterEdges = node.connectedEdges().stream().filter(Edge::isMasterEdge).collect(Collectors.toList());
            if ((long)masterEdges.size() >= valence || masterEdges.size() == 2 && masterEdges.stream().filter(connectedEdge -> connectedEdge.getOsmIdentifier() == edge.getOsmIdentifier()).count() > 1L) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    public ShortSegmentCheck(Configuration configuration) {
        super(configuration);
        this.maximumLength = this.configurationValue(configuration, "edge.length.maximum.meters", MAXIMUM_LENGTH_DEFAULT, Distance::meters);
        this.minimumValence = this.configurationValue(configuration, "node.valence.minimum", 3L);
        this.minimumHighwayPriority = Enum.valueOf(HighwayTag.class, this.configurationValue(configuration, "highway.priority.minimum", MINIMUM_HIGHWAY_PRIORITY_DEFAULT).toUpperCase());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).highwayTag().isMoreImportantThanOrEqualTo(this.minimumHighwayPriority) && ((Edge)object).isMasterEdge() && ((Edge)object).length().isLessThan(this.maximumLength);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        Optional<Node> lowValenceNodes = ShortSegmentCheck.getConnectedNodesWithValenceLessThan(edge, this.minimumValence);
        if (lowValenceNodes.isPresent() && !this.isGateLike((Edge)object)) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getIdentifier(), this.maximumLength.asMeters(), lowValenceNodes.get().getIdentifier(), this.minimumValence), Collections.singletonList(lowValenceNodes.get().getLocation())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean isGateLike(Edge object) {
        return object.start().connectedEdges().stream().filter(Edge::isMasterEdge).count() > 1L && Validators.hasValuesFor(object.end(), BarrierTag.class) || object.end().connectedEdges().stream().filter(Edge::isMasterEdge).count() > 1L && Validators.hasValuesFor(object.start(), BarrierTag.class);
    }
}

