/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.walker.SimpleEdgeWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class RoundaboutValenceCheck
extends BaseCheck {
    private static final long serialVersionUID = 1L;
    private static final String BASIC_INSTRUCTION = "This roundabout has improper valence.";
    private static final String WRONG_VALENCE_INSTRUCTIONS = "This roundabout has the wrong valence. It has a valence of {0,number,#}.";
    private static final String VALENCE_OF_ONE_INSTRUCTIONS = "This roundabout should be a turning loop or turning circle.";
    private static final String MINIMUM_NODE_VALENCE_INSTRUCTION = "This roundabout has a node, {0,number,#}, that has more than 1 connections outside the roundabout.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This roundabout has the wrong valence. It has a valence of {0,number,#}.", "This roundabout should be a turning loop or turning circle.", "This roundabout has a node, {0,number,#}, that has more than 1 connections outside the roundabout.", "This roundabout has improper valence.");
    private static final double LOWER_VALENCE_THRESHOLD_DEFAULT = 2.0;
    private final double minimumValence;

    public RoundaboutValenceCheck(Configuration configuration) {
        super(configuration);
        this.minimumValence = this.configurationValue(configuration, "connections.minimum", 2.0);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && JunctionTag.isRoundabout(object) && !this.isFlagged(object.getIdentifier()) && ((Edge)object).isMasterEdge() && HighwayTag.isCarNavigableHighway(object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        HashSet<String> instructions = new HashSet<String>();
        HashSet<AtlasItem> flaggedObjects = new HashSet<AtlasItem>();
        Set<Edge> roundaboutEdges = new SimpleEdgeWalker(edge, this.isRoundaboutEdge()).collectEdges();
        roundaboutEdges.forEach(roundaboutEdge -> this.markAsFlagged(roundaboutEdge.getIdentifier()));
        Set roundaboutNodes = roundaboutEdges.stream().map(Edge::start).collect(Collectors.toSet());
        int totalRoundaboutValence = 0;
        for (Node node : roundaboutNodes) {
            int nodeValence = node.connectedEdges().stream().filter(currentEdge -> HighwayTag.isCarNavigableHighway(currentEdge) && currentEdge.isMasterEdge() && !JunctionTag.isRoundabout(currentEdge) && !roundaboutEdges.contains(currentEdge)).collect(Collectors.toSet()).size();
            if (nodeValence > 1) {
                instructions.add(this.getLocalizedInstruction(2, node.getOsmIdentifier()));
                flaggedObjects.add(node);
            }
            totalRoundaboutValence += nodeValence;
        }
        if ((double)totalRoundaboutValence < this.minimumValence) {
            if (totalRoundaboutValence == 1) {
                instructions.add(this.getLocalizedInstruction(1, new Object[0]));
            }
            instructions.add(this.getLocalizedInstruction(0, totalRoundaboutValence));
        }
        if (!instructions.isEmpty()) {
            flaggedObjects.addAll(roundaboutEdges);
            CheckFlag flag = this.createFlag(flaggedObjects, this.getLocalizedInstruction(3, new Object[0]));
            instructions.forEach(flag::addInstruction);
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Function<Edge, Stream<Edge>> isRoundaboutEdge() {
        return edge -> edge.connectedEdges().stream().filter(connected -> JunctionTag.isRoundabout(connected) && HighwayTag.isCarNavigableHighway(connected));
    }
}

