/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;

public class RoundaboutConnectorCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -5311314357995383430L;
    private static final Double ONE_WAY_THRESHOLD_DEFAULT = 100.0;
    private static final Double TWO_WAY_THRESHOLD_DEFAULT = 130.0;
    private static final String ONE_WAY_INSTRUCTION = "This way, id:{0,number,#}, is connected to a roundabout at too sharp an angle. It may be digitized backwards";
    private static final String TWO_WAY_INSTRUCTION = "This way, id:{0,number,#}, is connected to a roundabout at too sharp an angle to be a two way road.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This way, id:{0,number,#}, is connected to a roundabout at too sharp an angle. It may be digitized backwards", "This way, id:{0,number,#}, is connected to a roundabout at too sharp an angle to be a two way road.");
    private static final String MINIMUM_HIGHWAY_DEFAULT = HighwayTag.SERVICE.toString();
    private final Angle oneWayThreshold;
    private final Angle twoWayThreshold;
    private final HighwayTag minimumHighwayType;

    public RoundaboutConnectorCheck(Configuration configuration) {
        super(configuration);
        this.oneWayThreshold = this.configurationValue(configuration, "threshold.one-way", ONE_WAY_THRESHOLD_DEFAULT, Angle::degrees);
        this.twoWayThreshold = this.configurationValue(configuration, "threshold.two-way", TWO_WAY_THRESHOLD_DEFAULT, Angle::degrees);
        this.minimumHighwayType = this.configurationValue(configuration, "minimum.highway.type", MINIMUM_HIGHWAY_DEFAULT, str -> Enum.valueOf(HighwayTag.class, str.toUpperCase()));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && !this.isFlagged(object.getOsmIdentifier()) && !JunctionTag.isRoundabout(object) && ((Edge)object).highwayTag().isMoreImportantThan(this.minimumHighwayType);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Optional<Heading> roundaboutHeading;
        Optional<Heading> edgeHeading;
        Edge edge = (Edge)object;
        Optional<Edge> optionalRoundaboutEdge = this.getRoundaboutEdge(edge);
        if (!optionalRoundaboutEdge.isPresent()) {
            return Optional.empty();
        }
        Edge roundaboutEdge = optionalRoundaboutEdge.get();
        String instruction = null;
        if (edge.inEdges().contains(roundaboutEdge)) {
            edgeHeading = edge.asPolyLine().initialHeading();
            roundaboutHeading = roundaboutEdge.asPolyLine().finalHeading();
        } else {
            edgeHeading = edge.asPolyLine().finalHeading();
            roundaboutHeading = roundaboutEdge.asPolyLine().initialHeading();
        }
        if (edgeHeading.isPresent() && roundaboutHeading.isPresent()) {
            if (edge.hasReverseEdge() && edgeHeading.get().difference(roundaboutHeading.get()).isGreaterThanOrEqualTo(this.twoWayThreshold)) {
                instruction = this.getLocalizedInstruction(1, object.getOsmIdentifier());
            } else if (!edge.hasReverseEdge() && edgeHeading.get().difference(roundaboutHeading.get()).isGreaterThanOrEqualTo(this.oneWayThreshold)) {
                instruction = this.getLocalizedInstruction(0, object.getOsmIdentifier());
            }
        }
        if (instruction != null) {
            this.markAsFlagged(edge.getOsmIdentifier());
            return Optional.of(this.createFlag(new OsmWayWalker(edge).collectEdges(), instruction));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Optional<Edge> getRoundaboutEdge(Edge edge) {
        return Stream.concat(edge.inEdges().stream(), edge.outEdges().stream()).filter(JunctionTag::isRoundabout).findFirst();
    }
}

