/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.OneWayTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class RoundaboutClosedLoopCheck
extends BaseCheck<Long> {
    public static final String ONE_WAY_INSTRUCTION = "This roundabout edge is not one-way.";
    private static final EnumSet<HighwayTag> HIGHWAY_TAGS_FOR_ROUNDABOUTS = EnumSet.of(HighwayTag.MINI_ROUNDABOUT, HighwayTag.TURNING_CIRCLE, HighwayTag.TURNING_LOOP);
    private static final int MINIMUM_VALENCE = 2;
    public static final String MINIMUM_VALENCE_INSTRUCTION = String.format("This roundabout edge has an end node that has less than %d connections.", 2);
    public static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This roundabout edge is not one-way.", MINIMUM_VALENCE_INSTRUCTION);
    private static final long serialVersionUID = -3648610800112828238L;

    private static boolean aConnectedNodeHasValenceLessThan(Edge edge, int valence) {
        return edge.connectedNodes().stream().anyMatch(node -> node.connectedEdges().stream().filter(Edge::isMasterEdge).count() < (long)valence);
    }

    private static boolean isAFormOfRoundabout(AtlasObject object) {
        Optional<HighwayTag> highwayTag = Validators.from(HighwayTag.class, object);
        return JunctionTag.isRoundabout(object) || highwayTag.isPresent() && HIGHWAY_TAGS_FOR_ROUNDABOUTS.contains((Object)highwayTag.get());
    }

    public RoundaboutClosedLoopCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && RoundaboutClosedLoopCheck.isAFormOfRoundabout(object) && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        if (!edge.isMasterEdge() || OneWayTag.isExplicitlyTwoWay(edge)) {
            this.markAsFlagged(object.getOsmIdentifier());
            return Optional.of(this.createFlag(new OsmWayWalker(edge).collectEdges(), this.getLocalizedInstruction(0, new Object[0])));
        }
        if (RoundaboutClosedLoopCheck.aConnectedNodeHasValenceLessThan(edge, 2)) {
            this.markAsFlagged(object.getOsmIdentifier());
            return Optional.of(this.createFlag(new OsmWayWalker(edge).collectEdges(), this.getLocalizedInstruction(1, new Object[0])));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

