/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class RoadLinkCheck
extends BaseCheck<Long> {
    public static final double DISTANCE_MILES_DEFAULT = 1.0;
    private static final String INVALID_LINK_DISTANCE_INSTRUCTION = "Invalid link, distance, {0}, greater than maximum, {1}.";
    private static final String NO_SAME_CLASSIFICATION_INSTRUCTION = "None of the connected edges contain any edges with the same classification [{0}]";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Invalid link, distance, {0}, greater than maximum, {1}.", "None of the connected edges contain any edges with the same classification [{0}]");
    private static final long serialVersionUID = 6828331285027997648L;
    private final Distance maximumLength;

    public RoadLinkCheck(Configuration configuration) {
        super(configuration);
        this.maximumLength = this.configurationValue(configuration, "length.maximum.miles", 1.0, Distance::miles);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).highwayTag().isLink() && ((Edge)object).isMasterEdge() && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        this.markAsFlagged(edge.getOsmIdentifier());
        if (edge.length().isGreaterThan(this.maximumLength)) {
            return Optional.of(this.createFlag(new OsmWayWalker(edge).collectEdges(), this.getLocalizedInstruction(0, edge.length(), this.maximumLength)));
        }
        if (edge.connectedEdges().stream().filter(Edge::isMasterEdge).noneMatch(connected -> connected.highwayTag().isOfEqualClassification(edge.highwayTag()))) {
            HashSet<Edge> geometry = new HashSet<Edge>();
            geometry.add(edge);
            geometry.addAll(edge.connectedEdges().stream().filter(Edge::isMasterEdge).collect(Collectors.toSet()));
            Set flagEdges = geometry.stream().flatMap(obj -> new OsmWayWalker((Edge)obj).collectEdges().stream()).collect(Collectors.toSet());
            CheckFlag flag = this.createFlag(flagEdges, this.getLocalizedInstruction(1, edge.highwayTag().toString()));
            flag.addPoint(edge.start().getLocation().midPoint(edge.end().getLocation()));
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

