/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.AerowayTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class FloatingEdgeCheck
extends BaseCheck<Long> {
    public static final double DISTANCE_MAXIMUM_KILOMETERS_DEFAULT = 100.0;
    public static final double DISTANCE_MINIMUM_METERS_DEFAULT = 100.0;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Way {0,number,#} is floating. It has no incoming or outgoing ways.");
    private static final long serialVersionUID = -6867668561001117411L;
    private static final String HIGHWAY_MINIMUM_DEFAULT = HighwayTag.SERVICE.toString();
    private final Distance maximumDistance;
    private final Distance minimumDistance;
    private final HighwayTag highwayMinimum;
    private final boolean checkConstructionRoad;

    private static boolean intersectsAirport(Edge edge) {
        return StreamSupport.stream(edge.getAtlas().areasIntersecting(edge.bounds(), area -> Validators.hasValuesFor(area, AerowayTag.class)).spliterator(), false).anyMatch(area -> area.asPolygon().overlaps(edge.asPolyLine()));
    }

    public FloatingEdgeCheck(Configuration configuration) {
        super(configuration);
        this.minimumDistance = this.configurationValue(configuration, "length.minimum.meters", 100.0, Distance::meters);
        this.maximumDistance = this.configurationValue(configuration, "length.maximum.kilometers", 100.0, Distance::kilometers);
        String highwayType = this.configurationValue(configuration, "highway.minimum", HIGHWAY_MINIMUM_DEFAULT);
        this.highwayMinimum = Enum.valueOf(HighwayTag.class, highwayType.toUpperCase());
        this.checkConstructionRoad = this.configurationValue(configuration, "construction.check", false);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TypePredicates.IS_EDGE.test(object) && ((Edge)object).isMasterEdge() && HighwayTag.isCarNavigableHighway(object) && this.isMinimumHighwayType(object) && !FloatingEdgeCheck.intersectsAirport((Edge)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        if (edge.length().isGreaterThanOrEqualTo(this.minimumDistance) && edge.length().isLessThanOrEqualTo(this.maximumDistance) && this.hasNoConnectedEdges(edge) && this.isNotOnSyntheticBoundary(edge) && (!this.checkConstructionRoad || ((Edge)object).connectedNodes().stream().noneMatch(node -> node.getAtlas().linesContaining(node.getLocation(), line -> Validators.isOfType((Taggable)line, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.CONSTRUCTION})).iterator().hasNext()))) {
            return Optional.of(this.createFlag((AtlasObject)edge, this.getLocalizedInstruction(0, object.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean hasNoConnectedEdges(Edge edge) {
        Set<Edge> connectedEdges = edge.connectedEdges();
        for (Edge connectedEdge : connectedEdges) {
            if (connectedEdge == null || edge.isReversedEdge(connectedEdge)) continue;
            return false;
        }
        return true;
    }

    private boolean isMinimumHighwayType(AtlasObject object) {
        Optional<HighwayTag> highwayTagOfObject = HighwayTag.highwayTag(object);
        return highwayTagOfObject.isPresent() && highwayTagOfObject.get().isMoreImportantThanOrEqualTo(this.highwayMinimum);
    }

    private boolean isNotOnSyntheticBoundary(Edge edge) {
        return !SyntheticBoundaryNodeTag.isBoundaryNode(edge.start()) && !SyntheticBoundaryNodeTag.isBoundaryNode(edge.end());
    }
}

