/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.atlas.predicates.TagPredicates;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.EdgeWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import scala.Tuple2;

public class EdgeCrossingEdgeCheck
extends BaseCheck<Long> {
    private static final String INSTRUCTION_FORMAT = "The road with id {0} has invalid crossings with {1}. If two roads are crossing each other, then they should have nodes at intersection locations unless they are explicitly marked as crossing. Otherwise, crossing roads should have different layer tags.";
    private static final String INVALID_EDGE_FORMAT = "Edge {0} is crossing invalidly with {1}.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The road with id {0} has invalid crossings with {1}. If two roads are crossing each other, then they should have nodes at intersection locations unless they are explicitly marked as crossing. Otherwise, crossing roads should have different layer tags.", "Edge {0} is crossing invalidly with {1}.");
    private static final String MINIMUM_HIGHWAY_DEFAULT = HighwayTag.NO.toString();
    private static final Long OSM_LAYER_DEFAULT = 0L;
    private static final long serialVersionUID = 2146863485833228593L;
    private final HighwayTag minimumHighwayType;

    private static boolean canCross(PolyLine edgeAsPolyLine, Optional<Long> edgeLayer, PolyLine crossingEdgeAsPolyLine, Optional<Long> crossingEdgeLayer, Location intersection) {
        return edgeAsPolyLine.contains(intersection) && crossingEdgeAsPolyLine.contains(intersection) || edgeLayer.isPresent() && crossingEdgeLayer.isPresent() && !edgeLayer.get().equals(crossingEdgeLayer.get());
    }

    public EdgeCrossingEdgeCheck(Configuration configuration) {
        super(configuration);
        this.minimumHighwayType = this.configurationValue(configuration, "minimum.highway.type", MINIMUM_HIGHWAY_DEFAULT, str -> Enum.valueOf(HighwayTag.class, str.toUpperCase()));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TypePredicates.IS_EDGE.test(object) && this.isValidCrossingEdge(object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Set<Edge> collectedEdges = new EdgeCrossingEdgeWalker((Edge)object, this.getInvalidCrossingEdges()).collectEdges();
        if (collectedEdges.size() > 1) {
            List edgeCrossPairs = collectedEdges.stream().filter(edge -> edge.getOsmIdentifier() != object.getOsmIdentifier()).map(edge -> new Tuple2(edge, new EdgeCrossingEdgeWalker((Edge)edge, this.getInvalidCrossingEdges()).collectEdges())).collect(Collectors.toList());
            edgeCrossPairs.add(new Tuple2((Object)((Edge)object), collectedEdges));
            Optional maxPair = edgeCrossPairs.stream().max((entry1, entry2) -> Integer.compare(((Set)entry1._2()).size(), ((Set)entry2._2()).size()));
            if (maxPair.isPresent()) {
                Tuple2 minPair;
                int maxSize = ((Set)((Tuple2)maxPair.get())._2()).size();
                List maxEdgePairs = edgeCrossPairs.stream().filter(crossPair -> ((Set)crossPair._2()).size() == maxSize).collect(Collectors.toList());
                Optional minIdentifierPair = maxEdgePairs.stream().reduce((edge1, edge2) -> ((Edge)edge1._1()).getOsmIdentifier() <= ((Edge)edge2._1()).getOsmIdentifier() ? edge1 : edge2);
                if (minIdentifierPair.isPresent() && !this.isFlagged(((Edge)(minPair = (Tuple2)minIdentifierPair.get())._1()).getIdentifier())) {
                    return this.createEdgeCrossCheckFlag((Edge)minPair._1(), (Set)minPair._2());
                }
            }
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Optional<CheckFlag> createEdgeCrossCheckFlag(Edge edge, Set<Edge> collectedEdges) {
        CheckFlag newFlag = new CheckFlag(this.getTaskIdentifier(edge));
        this.markAsFlagged(edge.getIdentifier());
        Set<Location> points = collectedEdges.stream().filter(crossEdge -> crossEdge.getIdentifier() != edge.getIdentifier()).flatMap(crossEdge -> this.getIntersection(edge, (Edge)crossEdge).stream()).collect(Collectors.toSet());
        newFlag.addInstruction(this.getLocalizedInstruction(0, edge.getIdentifier(), collectedEdges.stream().map(AtlasObject::getIdentifier).collect(Collectors.toList())));
        newFlag.addPoints(points);
        newFlag.addObject(edge);
        return Optional.of(newFlag);
    }

    private Set<Location> getIntersection(Edge edge1, Edge edge2) {
        PolyLine edge1AsPolyLine = edge1.asPolyLine();
        PolyLine edge2AsPolyLine = edge2.asPolyLine();
        return edge1AsPolyLine.intersections(edge2AsPolyLine);
    }

    private Function<Edge, Stream<Edge>> getInvalidCrossingEdges() {
        return edge -> {
            PolyLine edgeAsPolyLine = edge.asPolyLine();
            Rectangle edgeBounds = edge.bounds();
            Optional<Long> edgeLayer = Validators.hasValuesFor(edge, LayerTag.class) ? LayerTag.getTaggedValue(edge) : Optional.of(OSM_LAYER_DEFAULT);
            Atlas atlas = edge.getAtlas();
            return Iterables.asList(atlas.edgesIntersecting(edgeBounds, crossingEdge -> edge.getIdentifier() != crossingEdge.getIdentifier() && this.isValidCrossingEdge((AtlasObject)crossingEdge))).stream().filter(crossingEdge -> crossingEdge.getOsmIdentifier() != edge.getOsmIdentifier()).filter(crossingEdge -> {
                PolyLine crossingEdgeAsPolyLine = crossingEdge.asPolyLine();
                Optional<Long> crossingEdgeLayer = Validators.hasValuesFor(crossingEdge, LayerTag.class) ? LayerTag.getTaggedValue(crossingEdge) : Optional.of(OSM_LAYER_DEFAULT);
                return edgeAsPolyLine.intersections(crossingEdgeAsPolyLine).stream().anyMatch(intersection -> !EdgeCrossingEdgeCheck.canCross(edgeAsPolyLine, edgeLayer, crossingEdgeAsPolyLine, crossingEdgeLayer, intersection));
            });
        };
    }

    private boolean isValidCrossingEdge(AtlasObject object) {
        Optional<HighwayTag> highway;
        if (Edge.isMasterEdgeIdentifier(object.getIdentifier()) && !TagPredicates.IS_AREA.test(object) && (highway = HighwayTag.highwayTag(object)).isPresent()) {
            HighwayTag highwayTag = highway.get();
            return HighwayTag.isCarNavigableHighway(highwayTag) && !HighwayTag.CROSSING.equals((Object)highwayTag) && highwayTag.isMoreImportantThanOrEqualTo(this.minimumHighwayType);
        }
        return false;
    }

    private class EdgeCrossingEdgeWalker
    extends EdgeWalker {
        EdgeCrossingEdgeWalker(Edge startingEdge, Function<Edge, Stream<Edge>> nextCandidates) {
            super(startingEdge, nextCandidates);
        }
    }
}

