/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.flag.serializer;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.flag.CheckFlag;

public class CheckFlagDeserializer
implements JsonDeserializer<CheckFlag> {
    private static final String PROPERTIES = "properties";
    private static final String GENERATOR = "generator";
    private static final String INSTRUCTIONS = "instructions";
    private static final String ID = "id";
    private static final String IDENTIFIERS = "identifiers";

    @Override
    public CheckFlag deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        JsonObject full = json.getAsJsonObject();
        JsonObject properties = full.get(PROPERTIES).getAsJsonObject();
        String checkName = properties.get(GENERATOR).getAsString();
        String instruction = properties.get(INSTRUCTIONS).getAsString();
        String flagIdentifier = properties.get(IDENTIFIERS) == null ? properties.get(ID).getAsString() : this.parseIdentifiers((JsonArray)properties.get(IDENTIFIERS));
        CheckFlag flag = new CheckFlag(flagIdentifier);
        flag.addInstruction(instruction);
        flag.setChallengeName(checkName);
        return flag;
    }

    private String parseIdentifiers(JsonArray identifiers) {
        return Arrays.stream(new Gson().fromJson((JsonElement)identifiers, String[].class)).sorted().map(String::toString).collect(Collectors.joining(","));
    }
}

