/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.event;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Date;
import org.openstreetmap.atlas.checks.distributed.GeoJsonPathFilter;
import org.openstreetmap.atlas.checks.event.CheckFlagEvent;
import org.openstreetmap.atlas.checks.event.FileProcessor;
import org.openstreetmap.atlas.checks.vectortiles.TippecanoeCheckSettings;
import org.openstreetmap.atlas.event.ShutdownEvent;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckFlagTippecanoeProcessor
extends FileProcessor<CheckFlagEvent> {
    private static final Logger logger = LoggerFactory.getLogger(CheckFlagTippecanoeProcessor.class);

    public CheckFlagTippecanoeProcessor(SparkFileHelper fileHelper, String directory) {
        super(fileHelper, directory);
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void process(CheckFlagEvent event) {
        super.process(event.asLineDelimitedGeoJsonFeatures(TippecanoeCheckSettings.JSON_MUTATOR));
    }

    @Override
    @Subscribe
    public void process(ShutdownEvent event) {
        try {
            super.write();
        }
        catch (Exception e) {
            logger.warn("CheckFlagTippecanoeProcessor write failed.", (Throwable)e);
        }
    }

    @Override
    protected String getFilename() {
        return String.format("%s-%s%s", new Date().getTime(), this.getCount(), new GeoJsonPathFilter(this.doesCompressOutput()).getExtension());
    }
}

