/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.commands;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.openstreetmap.atlas.checks.configuration.ConfigurationResolver;
import org.openstreetmap.atlas.checks.constants.CommonConstants;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AbstractAtlasShellToolsCommand;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.terminal.TTYAttribute;
import org.openstreetmap.atlas.utilities.scalars.Counter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagStatisticsSubCommand
extends AbstractAtlasShellToolsCommand {
    private static final String INPUT_OPTION = "input";
    private static final String REFERENCE_OPTION = "reference";
    private static final String OUTPUT_OPTION = "output";
    private static final String OUTPUT_TYPES_OPTION = "output-types";
    private static final String GENERATOR = "generator";
    private static final String CHECK = "Check";
    private static final String INPUT = "Input";
    private static final String REFERENCE = "Reference";
    private static final String DIFFERENCE = "Difference";
    private static final String TOTAL = "Total";
    private static final String SUM_SUFFIX = "(sum)";
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationResolver.class);
    private final Gson gson = new Gson();
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();

    public static void main(String[] args) {
        new FlagStatisticsSubCommand().runSubcommandAndExit(args);
    }

    @Override
    public int execute() {
        Map<String, Map<String, Counter>> inputCounts = this.getCountryCheckCounts(this.optionAndArgumentDelegate.getOptionArgument(INPUT_OPTION).get());
        String outputFolder = this.optionAndArgumentDelegate.getOptionArgument(OUTPUT_OPTION).get();
        List<String> outputTypes = Arrays.asList(StringUtils.split(this.optionAndArgumentDelegate.getOptionArgument(OUTPUT_TYPES_OPTION).orElse(String.join((CharSequence)",", Arrays.stream(OutputTypes.values()).map(Enum::name).collect(Collectors.toSet()))).toUpperCase(), ','));
        try {
            if (outputTypes.contains(OutputTypes.RUN_SUMMARY.toString())) {
                this.writeCSV(outputFolder + "/runSummary.csv", this.generateFullOutput(inputCounts));
            }
            List<List<String>> totalsOutput = this.generateTotalsOutput(inputCounts);
            List<List<String>> countsOutput = this.generateCountsOutput(inputCounts);
            Optional<String> referenceFilePath = this.optionAndArgumentDelegate.getOptionArgument(REFERENCE_OPTION);
            if (referenceFilePath.isPresent()) {
                Map<String, Map<String, Counter>> referenceCounts = this.getCountryCheckCounts(referenceFilePath.get());
                Map<String, Map<String, Counter>> differenceCounts = this.getDifference(referenceCounts, inputCounts);
                if (outputTypes.contains(OutputTypes.RUN_SUMMARY.toString())) {
                    this.writeCSV(outputFolder + "/runSummaryDifference.csv", this.generateFullOutput(differenceCounts));
                }
                totalsOutput = this.addReferenceAndDifferenceToTotalsOutput(totalsOutput, referenceCounts, differenceCounts);
                countsOutput = this.addReferenceAndDifferenceToCountsOutput(countsOutput, referenceCounts, differenceCounts);
            }
            if (outputTypes.contains(OutputTypes.CHECK_SUMMARY.toString())) {
                this.writeCSV(outputFolder + "/checkSummary.csv", totalsOutput);
            }
            if (outputTypes.contains(OutputTypes.CHECK_BY_COUNTRY.toString())) {
                this.writeCSV(outputFolder + "/checkByCountry.csv", countsOutput);
            }
        }
        catch (IOException exception) {
            this.outputDelegate.printlnStderr(exception.toString(), new TTYAttribute[0]);
            return 1;
        }
        return 0;
    }

    @Override
    public String getCommandName() {
        return "flag-statistics";
    }

    @Override
    public String getSimpleDescription() {
        return "get flag counts for a set of atlas checks' log files";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", FlagStatisticsSubCommand.class.getResourceAsStream("FlagStatisticsSubCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", FlagStatisticsSubCommand.class.getResourceAsStream("FlagStatisticsSubCommandExamplesSection.txt"));
    }

    @Override
    public void registerOptionsAndArguments() {
        this.registerOptionWithRequiredArgument(INPUT_OPTION, Character.valueOf('i'), "A directory of folders containing atlas-checks log files.", OptionOptionality.REQUIRED, INPUT_OPTION, new Integer[0]);
        this.registerOptionWithRequiredArgument(REFERENCE_OPTION, Character.valueOf('r'), "A second set of log files to diff against.", OptionOptionality.OPTIONAL, REFERENCE_OPTION, new Integer[0]);
        this.registerOptionWithRequiredArgument(OUTPUT_OPTION, Character.valueOf('o'), "A folder to output results to.", OptionOptionality.REQUIRED, OUTPUT_OPTION, new Integer[0]);
        this.registerOptionWithRequiredArgument(OUTPUT_TYPES_OPTION, Character.valueOf('t'), "A comma separated list of outputs to generate: run_summary,check_summary,check_by_country", OptionOptionality.OPTIONAL, OUTPUT_TYPES_OPTION, new Integer[0]);
        super.registerOptionsAndArguments();
    }

    private List<List<String>> addReferenceAndDifferenceToCountsOutput(List<List<String>> stage1Output, Map<String, Map<String, Counter>> referenceCountryCheckCounts, Map<String, Map<String, Counter>> diffCountryCheckCounts) {
        ArrayList<List<String>> outputLines = new ArrayList<List<String>>(stage1Output);
        ((List)outputLines.get(0)).add(2, REFERENCE);
        ((List)outputLines.get(0)).add(DIFFERENCE);
        for (int index = 1; index < outputLines.size(); ++index) {
            Optional<Long> referenceCount;
            stage1Output.get(index).add(2, (referenceCount = this.getCountryCheckCount(referenceCountryCheckCounts, stage1Output.get(index).get(0), stage1Output.get(index).get(1))).isPresent() ? String.valueOf(referenceCount.get()) : "");
            Optional<Long> differenceCount = this.getCountryCheckCount(diffCountryCheckCounts, stage1Output.get(index).get(0), stage1Output.get(index).get(1));
            stage1Output.get(index).add(differenceCount.isPresent() ? String.valueOf(differenceCount.get()) : "");
        }
        return outputLines;
    }

    private List<List<String>> addReferenceAndDifferenceToTotalsOutput(List<List<String>> stage1Output, Map<String, Map<String, Counter>> referenceCountryCheckCounts, Map<String, Map<String, Counter>> diffCountryCheckCounts) {
        ArrayList<List<String>> outputLines = new ArrayList<List<String>>(stage1Output);
        ((List)outputLines.get(0)).add(1, "Reference(sum)");
        ((List)outputLines.get(0)).add("Difference(sum)");
        for (int index = 1; index < outputLines.size(); ++index) {
            String check = (String)((List)outputLines.get(index)).get(0);
            ((List)outputLines.get(index)).add(1, String.valueOf(this.getCheckTotal(referenceCountryCheckCounts, check)));
            ((List)outputLines.get(index)).add(String.valueOf(this.getCheckTotal(diffCountryCheckCounts, check)));
        }
        return outputLines;
    }

    private List<List<String>> generateCountsOutput(Map<String, Map<String, Counter>> countryCheckCounts) {
        ArrayList<String> countries = new ArrayList<String>(countryCheckCounts.keySet());
        Collections.sort(countries);
        List checks = countryCheckCounts.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).keySet().stream()).distinct().sorted().collect(Collectors.toList());
        ArrayList<List<String>> outputLines = new ArrayList<List<String>>();
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Country");
        headers.add(CHECK);
        headers.add(INPUT);
        outputLines.add(headers);
        countries.forEach(country -> checks.forEach(check -> {
            ArrayList<String> countryCheckRow = new ArrayList<String>();
            countryCheckRow.add((String)country);
            countryCheckRow.add((String)check);
            Optional<Long> count = this.getCountryCheckCount(countryCheckCounts, (String)country, (String)check);
            if (count.isPresent()) {
                countryCheckRow.add(String.valueOf(count.get()));
            } else {
                countryCheckRow.add("");
            }
            outputLines.add(countryCheckRow);
        }));
        return outputLines;
    }

    private List<List<String>> generateFullOutput(Map<String, Map<String, Counter>> countryCheckCounts) {
        ArrayList<String> countries = new ArrayList<String>(countryCheckCounts.keySet());
        Collections.sort(countries);
        List<String> checks = countryCheckCounts.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).keySet().stream()).distinct().sorted().collect(Collectors.toList());
        ArrayList<List<String>> outputLines = new ArrayList<List<String>>();
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(CHECK);
        headers.addAll(countries);
        headers.add(TOTAL);
        outputLines.add(headers);
        checks.forEach(check -> {
            ArrayList<String> checkRow = new ArrayList<String>();
            checkRow.add((String)check);
            checkRow.addAll(countries.stream().map(country -> {
                Optional<Long> count = this.getCountryCheckCount(countryCheckCounts, (String)country, (String)check);
                if (count.isPresent()) {
                    return String.valueOf(count.get());
                }
                return "";
            }).collect(Collectors.toList()));
            checkRow.add(String.valueOf(this.getCheckTotal(countryCheckCounts, (String)check)));
            outputLines.add(checkRow);
        });
        ArrayList<String> totals = new ArrayList<String>();
        totals.add(TOTAL);
        List countryCounts = countries.stream().map(country -> ((Map)countryCheckCounts.get(country)).entrySet().stream().mapToLong(entry -> ((Counter)entry.getValue()).getValue()).sum()).collect(Collectors.toList());
        totals.addAll(countryCounts.stream().map(String::valueOf).collect(Collectors.toList()));
        totals.add(String.valueOf(countryCounts.stream().mapToLong(Long::longValue).sum()));
        outputLines.add(totals);
        return outputLines;
    }

    private List<List<String>> generateTotalsOutput(Map<String, Map<String, Counter>> countryCheckCounts) {
        List<String> checks = countryCheckCounts.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).keySet().stream()).distinct().sorted().collect(Collectors.toList());
        ArrayList<List<String>> outputLines = new ArrayList<List<String>>();
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(CHECK);
        headers.add("Input(sum)");
        outputLines.add(headers);
        checks.forEach(check -> {
            ArrayList<String> checkRow = new ArrayList<String>();
            checkRow.add((String)check);
            checkRow.add(String.valueOf(this.getCheckTotal(countryCheckCounts, (String)check)));
            outputLines.add(checkRow);
        });
        return outputLines;
    }

    private long getCheckTotal(Map<String, Map<String, Counter>> countryCheckCounts, String check) {
        return countryCheckCounts.keySet().stream().mapToLong(country -> ((Map)countryCheckCounts.get(country)).getOrDefault(check, new Counter()).getValue()).sum();
    }

    private Optional<Long> getCountryCheckCount(Map<String, Map<String, Counter>> countryCheckCounts, String country, String check) {
        if (countryCheckCounts.containsKey(country) && countryCheckCounts.get(country).containsKey(check)) {
            return Optional.of(countryCheckCounts.get(country).get(check).getValue());
        }
        return Optional.empty();
    }

    private Map<String, Map<String, Counter>> getCountryCheckCounts(String path) {
        logger.info("Reading files from: {}", (Object)path);
        return new File(path).listFilesRecursively().parallelStream().filter(file -> FilenameUtils.getExtension(file.isGzipped() ? FilenameUtils.getBaseName(file.getName()) : file.getName()).equalsIgnoreCase("log")).map(file -> {
            HashMap countryCheckMap = new HashMap();
            logger.info("Reading: {}", (Object)file.getName());
            String country = FilenameUtils.getName(file.getParent());
            countryCheckMap.putIfAbsent(country, new HashMap());
            try (InputStreamReader inputStreamReader = file.isGzipped() ? new InputStreamReader(new GZIPInputStream(new FileInputStream(file.getFile()))) : new FileReader(file.getPath());
                 BufferedReader reader = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = reader.readLine()) != null) {
                    JsonObject source = this.gson.fromJson(line, JsonObject.class);
                    String checkName = source.get("properties").getAsJsonObject().get(GENERATOR).getAsString();
                    ((Map)countryCheckMap.get(country)).putIfAbsent(checkName, new Counter());
                    ((Counter)((Map)countryCheckMap.get(country)).get(checkName)).increment();
                }
            }
            catch (IOException exception) {
                this.outputDelegate.printlnWarnMessage(String.format("Exception thrown while reading file %s: %s", file.getName(), exception.getMessage()));
            }
            return countryCheckMap;
        }).collect(HashMap::new, this::mergeMaps, this::mergeMaps);
    }

    private Map<String, Map<String, Counter>> getDifference(Map<String, Map<String, Counter>> source, Map<String, Map<String, Counter>> target) {
        HashMap<String, Map<String, Counter>> difference = new HashMap<String, Map<String, Counter>>();
        source.forEach((country, checkCounts) -> {
            difference.putIfAbsent((String)country, new HashMap());
            checkCounts.forEach((check, count) -> ((Map)difference.get(country)).put(check, new Counter(((Map)target.getOrDefault(country, new HashMap())).getOrDefault(check, new Counter()).getValue() - count.getValue())));
        });
        target.forEach((country, checkCounts) -> {
            difference.putIfAbsent((String)country, new HashMap());
            checkCounts.forEach((check, count) -> ((Map)difference.get(country)).putIfAbsent(check, count));
        });
        return difference;
    }

    private Map<String, Map<String, Counter>> mergeMaps(Map<String, Map<String, Counter>> place, Map<String, Map<String, Counter>> put) {
        put.forEach((country, checks) -> {
            place.putIfAbsent((String)country, new HashMap());
            checks.forEach((check, counter) -> {
                ((Map)place.get(country)).putIfAbsent(check, new Counter());
                ((Counter)((Map)place.get(country)).get(check)).add(counter.getValue());
            });
        });
        return place;
    }

    private void writeCSV(String outputPath, List<List<String>> table) throws IOException {
        String outputString = table.stream().map(line -> String.join((CharSequence)",", line)).collect(Collectors.joining(CommonConstants.LINE_SEPARATOR));
        try (FileWriter outputWriter = new FileWriter(new File(outputPath).getFile());){
            outputWriter.write(outputString);
        }
    }

    private static enum OutputTypes {
        RUN_SUMMARY,
        CHECK_SUMMARY,
        CHECK_BY_COUNTRY;

    }
}

