/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.base;

import com.google.common.collect.Streams;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.base.Check;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckResourceLoader {
    private static final String DEFAULT_ENABLED_KEY_TEMPLATE = "%s.enabled";
    private static final String DEFAULT_PACKAGE = "org.openstreetmap.atlas.checks";
    private static final String DEFAULT_TYPE = Check.class.getName();
    private static final Logger logger = LoggerFactory.getLogger(CheckResourceLoader.class);
    private final Class<?> checkType;
    private final Configuration configuration;
    private final MultiMap<String, String> countryGroups = new MultiMap();
    private final Boolean enabledByDefault;
    private final String enabledKeyTemplate;
    private static final String COUNTRY_WHITELIST_TEMPLATE = "%s.countries.whitelist";
    private static final String COUNTRY_BLACKLIST_TEMPLATE = "%s.countries.blacklist";
    private final Set<String> packages;
    private final Optional<List<String>> checkWhiteList;
    private final Optional<List<String>> checkBlackList;

    public CheckResourceLoader(Configuration configuration) {
        this.packages = Collections.unmodifiableSet(Iterables.asSet((Iterable)configuration.get("CheckResourceLoader.scanUrls", Collections.singletonList(DEFAULT_PACKAGE)).value()));
        Map groups = (Map)configuration.get("groups", Collections.emptyMap()).value();
        groups.keySet().forEach(group -> ((List)groups.get(group)).forEach(country -> this.countryGroups.add((String)country, (String)group)));
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            this.checkType = loader.loadClass((String)configuration.get("CheckResourceLoader.type", DEFAULT_TYPE).value());
        }
        catch (ClassNotFoundException classNotFound) {
            throw new CoreException("Unable to initialize CheckResourceLoader", classNotFound);
        }
        this.enabledByDefault = (Boolean)configuration.get("CheckResourceLoader.enabled.value.default", false).value();
        this.enabledKeyTemplate = (String)configuration.get("CheckResourceLoader.enabledKeyTemplate", DEFAULT_ENABLED_KEY_TEMPLATE).value();
        this.configuration = configuration;
        this.checkWhiteList = configuration.get("CheckResourceLoader.checks.whitelist").valueOption();
        this.checkBlackList = configuration.get("CheckResourceLoader.checks.blacklist").valueOption();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Configuration getConfigurationForCountry(String country) {
        Configuration specializedConfiguration = this.configuration.configurationForKeyword(country);
        Object groups = this.countryGroups.get(country);
        if (groups != null) {
            Iterator iterator = groups.iterator();
            while (iterator.hasNext()) {
                String group = (String)iterator.next();
                specializedConfiguration = specializedConfiguration.configurationForKeyword(group);
            }
        }
        return specializedConfiguration;
    }

    public <T extends Check> Set<T> loadChecks(Predicate<Class> isEnabled) {
        return this.loadChecks(isEnabled, this.configuration);
    }

    public <T extends Check> Set<T> loadChecks(Configuration configuration) {
        return this.loadChecks(this::isEnabledByConfiguration, configuration);
    }

    public <T extends Check> Set<T> loadChecks(Predicate<Class> isEnabled, Configuration configuration) {
        Class[][] constructorArgumentTypes = new Class[][]{{Configuration.class}, new Class[0]};
        Object[][] constructorArguments = new Object[][]{{configuration}, new Object[0]};
        return this.loadChecksUsingConstructors(isEnabled, constructorArgumentTypes, constructorArguments);
    }

    public <T extends Check> Set<T> loadChecks() {
        return this.loadChecks(this::isEnabledByConfiguration, this.configuration);
    }

    public <T extends Check> Set<T> loadChecksForCountry(String country) {
        Configuration countryConfiguration = this.getConfigurationForCountry(country);
        return this.loadChecks(checkClass -> this.isEnabledByConfiguration(countryConfiguration, (Class)checkClass, country), countryConfiguration);
    }

    public <T extends Check> Set<T> loadChecksUsingConstructors(Class<?>[][] constructorArgumentTypes, Object[][] constructorArguments) {
        return this.loadChecksUsingConstructors(this::isEnabledByConfiguration, constructorArgumentTypes, constructorArguments);
    }

    public <T extends Check> Set<T> loadChecksUsingConstructors(Predicate<Class> isEnabled, Class<?>[][] constructorArgumentTypes, Object[][] constructorArguments) {
        HashSet checks = new HashSet();
        Time time = Time.now();
        try {
            ClassPath classPath = ClassPath.from(Thread.currentThread().getContextClassLoader());
            this.packages.forEach(packageName -> classPath.getTopLevelClassesRecursive((String)packageName).forEach(classInfo -> {
                Class<?> checkClass = classInfo.load();
                if (this.checkType.isAssignableFrom(checkClass) && !Modifier.isAbstract(checkClass.getModifiers()) && isEnabled.test(checkClass) && this.checkWhiteList.map(whitelist -> whitelist.contains(checkClass.getSimpleName())).orElse(true).booleanValue() && this.checkBlackList.map(blacklist -> !blacklist.contains(checkClass.getSimpleName())).orElse(true).booleanValue()) {
                    Streams.zip(Stream.of(constructorArgumentTypes), Stream.of(constructorArguments), (argTypes, args) -> this.initializeCheckWithArguments(checkClass, (Class<?>[])argTypes, (Object[])args)).filter(Optional::isPresent).map(Optional::get).findFirst().ifPresent(checks::add);
                }
            }));
        }
        catch (IOException oops) {
            throw new CoreException("Failed to discover {} classes on classpath", this.checkType.getSimpleName());
        }
        logger.info("Loaded {} {} in {}", new Object[]{checks.size(), this.checkType.getSimpleName(), time.elapsedSince()});
        return checks;
    }

    private <T extends Check> Optional<T> initializeCheckWithArguments(Class<T> checkClass, Class<?>[] constructorArgumentTypes, Object[] constructorArguments) {
        try {
            Constructor<T> constructor = checkClass.getConstructor(constructorArgumentTypes);
            Check result = (Check)constructor.newInstance(constructorArguments);
            return Optional.of(result);
        }
        catch (NoSuchMethodException oops) {
            logger.info("No method found for {} with arguments {}", checkClass, (Object)Stream.of(constructorArgumentTypes).map(Class::toString).collect(Collectors.joining(",")));
        }
        catch (InvocationTargetException oops) {
            logger.error("Unable to create a configurable instance of {}. Reason {}", (Object)checkClass.getSimpleName(), (Object)oops.getMessage());
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException oops) {
            logger.error("Failed to instantiate {}, ignoring. Reason: {}", (Object)checkClass.getName(), (Object)oops.getMessage());
        }
        return Optional.empty();
    }

    private boolean isEnabledByConfiguration(Class checkClass) {
        return this.isEnabledByConfiguration(this.configuration, checkClass);
    }

    private boolean isEnabledByConfiguration(Configuration configuration, Class checkClass) {
        String key = String.format(this.enabledKeyTemplate, checkClass.getSimpleName());
        return (Boolean)configuration.get(key, this.enabledByDefault).value();
    }

    private boolean isEnabledByConfiguration(Configuration configuration, Class checkClass, String country) {
        List countryWhitelist = (List)configuration.get(String.format(COUNTRY_WHITELIST_TEMPLATE, checkClass.getSimpleName()), Collections.emptyList()).value();
        List countryBlacklist = (List)configuration.get(String.format(COUNTRY_BLACKLIST_TEMPLATE, checkClass.getSimpleName()), Collections.emptyList()).value();
        return this.isEnabledByConfiguration(configuration, checkClass) && countryWhitelist.isEmpty() ? !countryBlacklist.contains(country) : countryWhitelist.contains(country);
    }
}

