/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.util.logging.CommonsLogger;
import org.geotools.util.logging.LoggerFactory;

public class CommonsLoggerFactory
extends LoggerFactory<Log> {
    private static CommonsLoggerFactory factory;

    protected CommonsLoggerFactory() throws NoClassDefFoundError {
        super(Log.class);
    }

    public static synchronized CommonsLoggerFactory getInstance() throws NoClassDefFoundError {
        if (factory == null) {
            factory = new CommonsLoggerFactory();
        }
        return factory;
    }

    @Override
    protected Log getImplementation(String name) {
        Log log = LogFactory.getLog(name);
        if (log != null && log.getClass().getName().equals("org.apache.commons.logging.impl.Jdk14Logger")) {
            return null;
        }
        return log;
    }

    @Override
    protected Logger wrap(String name, Log implementation) {
        return new CommonsLogger(name, implementation);
    }

    @Override
    protected Log unwrap(Logger logger) {
        if (logger instanceof CommonsLogger) {
            return ((CommonsLogger)logger).logger;
        }
        return null;
    }
}

