/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.Arrays;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CurvedRing;
import org.geotools.geometry.jts.GrowableOrdinateArray;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class CircularRing
extends LinearRing
implements SingleCurvedGeometry<LinearRing>,
CurvedRing {
    private static final long serialVersionUID = -5796254063449438787L;
    static final CoordinateSequence FAKE_RING_2D = new CoordinateArraySequence(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 1.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 0.0)});
    CircularString delegate;

    public CircularRing(CoordinateSequence points, GeometryFactory factory, double tolerance) {
        super(FAKE_RING_2D, factory);
        this.delegate = new CircularString(points, factory, tolerance);
        if (!this.delegate.isClosed()) {
            throw new IllegalArgumentException("Start and end point are not matching, this is not a ring");
        }
    }

    public CircularRing(double[] controlPoints, GeometryFactory factory, double tolerance) {
        super(FAKE_RING_2D, factory);
        this.delegate = new CircularString(controlPoints, factory, tolerance);
        if (!this.delegate.isClosed()) {
            throw new IllegalArgumentException("Start and end point are not matching, this is not a ring");
        }
    }

    @Override
    public int getNumArcs() {
        return this.delegate.getNumArcs();
    }

    @Override
    public CircularArc getArcN(int arcIndex) {
        return this.delegate.getArcN(arcIndex);
    }

    @Override
    public LinearRing linearize() {
        CoordinateSequence cs = this.delegate.getLinearizedCoordinateSequence(this.delegate.tolerance);
        return this.getFactory().createLinearRing(cs);
    }

    @Override
    public LinearRing linearize(double tolerance) {
        CoordinateSequence cs = this.delegate.getLinearizedCoordinateSequence(this.delegate.tolerance);
        return this.getFactory().createLinearRing(cs);
    }

    @Override
    public double getTolerance() {
        return this.delegate.getTolerance();
    }

    @Override
    public CoordinateSequence getLinearizedCoordinateSequence(double tolerance) {
        return this.delegate.getLinearizedCoordinateSequence(tolerance);
    }

    @Override
    public double[] getControlPoints() {
        return this.delegate.controlPoints;
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public int getDimension() {
        return super.getDimension();
    }

    @Override
    public int getBoundaryDimension() {
        return super.getDimension();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getGeometryType() {
        return "CircularRing";
    }

    @Override
    public int getCoordinatesDimension() {
        return this.delegate.getDimension();
    }

    public CircularRing normalizeRing() {
        if (!this.isClosed() || this.getNumArcs() > 1) {
            return this;
        }
        CircularArc arc = this.getArcN(0);
        Coordinate center = arc.getCenter();
        double radius = arc.getRadius();
        double[] cp = arc.getControlPoints();
        double angle1 = Math.atan2(cp[1] - center.y, cp[0] - center.x);
        double angle2 = Math.atan2(cp[3] - center.y, cp[2] - center.x);
        double am1 = (angle1 + angle2) / 2.0;
        double am2 = am1 + Math.PI;
        double[] ncp = new double[]{cp[0], cp[1], center.x + radius * Math.cos(am1), center.y + radius * Math.sin(am1), cp[2], cp[3], center.x + radius * Math.cos(am2), center.y + radius * Math.sin(am2), cp[0], cp[1]};
        return new CircularRing(ncp, this.factory, this.delegate.getTolerance());
    }

    @Override
    public Geometry reverse() {
        double[] controlPoints = this.delegate.controlPoints;
        GrowableOrdinateArray array = new GrowableOrdinateArray();
        array.addAll(controlPoints);
        array.reverseOrdinates(0, array.size() - 1);
        return new CircularRing(array.getData(), this.getFactory(), this.delegate.tolerance);
    }

    @Override
    public int getNumGeometries() {
        return 1;
    }

    @Override
    public Geometry getGeometryN(int n) {
        return this;
    }

    @Override
    public void setUserData(Object userData) {
        super.setUserData(userData);
    }

    @Override
    public int getSRID() {
        return super.getSRID();
    }

    @Override
    public void setSRID(int SRID) {
        super.setSRID(SRID);
    }

    @Override
    public GeometryFactory getFactory() {
        return super.getFactory();
    }

    @Override
    public Object getUserData() {
        return super.getUserData();
    }

    @Override
    public PrecisionModel getPrecisionModel() {
        return super.getPrecisionModel();
    }

    @Override
    public boolean isRectangle() {
        return false;
    }

    @Override
    public Point getInteriorPoint() {
        return this.delegate.getInteriorPoint();
    }

    @Override
    public Geometry getEnvelope() {
        return this.delegate.getEnvelope();
    }

    @Override
    public Envelope getEnvelopeInternal() {
        return this.delegate.getEnvelopeInternal();
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        return this.delegate.getEnvelopeInternal();
    }

    @Override
    public boolean equalsExact(Geometry other) {
        return this.equalsExact(other, 0.0);
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (other instanceof CircularRing) {
            CircularRing csOther = (CircularRing)other;
            if (Arrays.equals(this.delegate.controlPoints, csOther.delegate.controlPoints)) {
                return true;
            }
        }
        return this.linearize(tolerance).equalsExact(other, tolerance);
    }

    @Override
    public boolean equals(Geometry other) {
        if (other instanceof CircularRing) {
            CircularRing csOther = (CircularRing)other;
            if (Arrays.equals(this.delegate.controlPoints, csOther.delegate.controlPoints)) {
                return true;
            }
        }
        return this.linearize().equals(other);
    }

    @Override
    public boolean equalsTopo(Geometry other) {
        if (other instanceof CircularRing) {
            CircularRing csOther = (CircularRing)other;
            if (Arrays.equals(this.delegate.controlPoints, csOther.delegate.controlPoints)) {
                return true;
            }
        }
        return this.linearize().equalsTopo(other);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Geometry) {
            return this.equals((Geometry)o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return this.toCurvedText();
    }

    @Override
    public String toCurvedText() {
        return this.delegate.toCurvedText();
    }

    @Override
    public boolean equalsNorm(Geometry g2) {
        return super.equalsNorm(g2);
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.linearize().getCoordinates();
    }

    @Override
    public CoordinateSequence getCoordinateSequence() {
        if (this.delegate != null) {
            return this.linearize().getCoordinateSequence();
        }
        return super.getCoordinateSequence();
    }

    @Override
    public Coordinate getCoordinateN(int n) {
        if (this.delegate != null) {
            return this.linearize().getCoordinateN(n);
        }
        return super.getCoordinateN(n);
    }

    @Override
    public Coordinate getCoordinate() {
        return this.linearize().getCoordinate();
    }

    @Override
    public int getNumPoints() {
        if (this.delegate != null) {
            return this.linearize().getNumPoints();
        }
        return super.getNumPoints();
    }

    @Override
    public Point getPointN(int n) {
        return this.linearize().getPointN(n);
    }

    @Override
    public Point getStartPoint() {
        return this.linearize().getStartPoint();
    }

    @Override
    public Point getEndPoint() {
        return this.linearize().getEndPoint();
    }

    @Override
    public boolean isRing() {
        return this.linearize().isRing();
    }

    @Override
    public double getLength() {
        return this.linearize().getLength();
    }

    @Override
    public Geometry getBoundary() {
        return this.linearize().getBoundary();
    }

    @Override
    public boolean isCoordinate(Coordinate pt) {
        return this.linearize().isCoordinate(pt);
    }

    @Override
    public void apply(CoordinateFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public void apply(GeometryFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public CircularRing copyInternal() {
        return new CircularRing(this.getControlPoints(), this.factory, this.getTolerance());
    }

    @Override
    public void normalize() {
        this.linearize().normalize();
    }

    @Override
    public boolean isSimple() {
        return this.linearize().isSimple();
    }

    @Override
    public boolean isValid() {
        return this.linearize().isValid();
    }

    @Override
    public double distance(Geometry g2) {
        return this.linearize().distance(g2);
    }

    @Override
    public boolean isWithinDistance(Geometry geom, double distance) {
        return this.linearize().isWithinDistance(geom, distance);
    }

    @Override
    public double getArea() {
        return this.linearize().getArea();
    }

    @Override
    public Point getCentroid() {
        return this.linearize().getCentroid();
    }

    @Override
    public void geometryChanged() {
        this.linearize().geometryChanged();
    }

    @Override
    public boolean disjoint(Geometry g2) {
        return this.linearize().disjoint(g2);
    }

    @Override
    public boolean touches(Geometry g2) {
        return this.linearize().touches(g2);
    }

    @Override
    public boolean intersects(Geometry g2) {
        return this.linearize().intersects(g2);
    }

    @Override
    public boolean crosses(Geometry g2) {
        return this.linearize().crosses(g2);
    }

    @Override
    public boolean within(Geometry g2) {
        return this.linearize().within(g2);
    }

    @Override
    public boolean contains(Geometry g2) {
        return this.linearize().contains(g2);
    }

    @Override
    public boolean overlaps(Geometry g2) {
        return this.linearize().overlaps(g2);
    }

    @Override
    public boolean covers(Geometry g2) {
        return this.linearize().covers(g2);
    }

    @Override
    public boolean coveredBy(Geometry g2) {
        return this.linearize().coveredBy(g2);
    }

    @Override
    public boolean relate(Geometry g2, String intersectionPattern) {
        return this.linearize().relate(g2, intersectionPattern);
    }

    @Override
    public IntersectionMatrix relate(Geometry g2) {
        return this.linearize().relate(g2);
    }

    @Override
    public Geometry buffer(double distance) {
        return this.linearize().buffer(distance);
    }

    @Override
    public Geometry buffer(double distance, int quadrantSegments) {
        return this.linearize().buffer(distance, quadrantSegments);
    }

    @Override
    public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
        return this.linearize().buffer(distance, quadrantSegments, endCapStyle);
    }

    @Override
    public Geometry convexHull() {
        return this.linearize().convexHull();
    }

    @Override
    public Geometry intersection(Geometry other) {
        return this.linearize().intersection(other);
    }

    @Override
    public Geometry union(Geometry other) {
        return this.linearize().union(other);
    }

    @Override
    public Geometry difference(Geometry other) {
        return this.linearize().difference(other);
    }

    @Override
    public Geometry symDifference(Geometry other) {
        return this.linearize().symDifference(other);
    }

    @Override
    public Geometry union() {
        return this.linearize().union();
    }

    @Override
    public Geometry norm() {
        return this.linearize().norm();
    }

    @Override
    public int compareTo(Object o) {
        return this.linearize().compareTo(o);
    }

    @Override
    public int compareTo(Object o, CoordinateSequenceComparator comp) {
        return this.linearize().compareTo(o, comp);
    }

    @Override
    public String toText() {
        return this.linearize().toText();
    }
}

