/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.geotools.gml.producer.GeometryTransformer;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class FilterTransformer
extends TransformerBase {
    private static String defaultNamespace = "http://www.opengis.net/ogc";
    private static Map comparisions = new HashMap();
    private static Map spatial = new HashMap();
    private static Map logical = new HashMap();

    public String transform(Filter f) throws TransformerException {
        return super.transform(f);
    }

    @Override
    public Translator createTranslator(ContentHandler handler) {
        return new FilterTranslator(handler);
    }

    public static class FilterTranslator
    extends TransformerBase.TranslatorSupport
    implements FilterVisitor,
    ExpressionVisitor {
        GeometryTransformer.GeometryTranslator geometryEncoder;

        public FilterTranslator(ContentHandler handler) {
            super(handler, "ogc", defaultNamespace);
            this.geometryEncoder = new GeometryTransformer.GeometryTranslator(handler);
            this.addNamespaceDeclarations(this.geometryEncoder);
        }

        @Override
        public Object visit(ExcludeFilter filter, Object extraData) {
            return extraData;
        }

        @Override
        public Object visit(IncludeFilter filter, Object extraData) {
            return extraData;
        }

        @Override
        public Object visit(And filter, Object extraData) {
            this.start("And");
            for (Filter child : filter.getChildren()) {
                child.accept(this, extraData);
            }
            this.end("And");
            return extraData;
        }

        @Override
        public Object visit(Id filter, Object extraData) {
            Set<Identifier> fids = filter.getIdentifiers();
            for (Identifier fid : fids) {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute(null, "fid", "fid", null, fid.toString());
                this.element("FeatureId", null, atts);
            }
            return extraData;
        }

        @Override
        public Object visit(Not filter, Object extraData) {
            this.start("Not");
            filter.getFilter().accept(this, extraData);
            this.end("Not");
            return extraData;
        }

        @Override
        public Object visit(Or filter, Object extraData) {
            this.start("Or");
            for (Filter child : filter.getChildren()) {
                child.accept(this, extraData);
            }
            this.end("Or");
            return extraData;
        }

        @Override
        public Object visit(PropertyIsBetween filter, Object extraData) {
            Expression left = filter.getLowerBoundary();
            Expression mid = filter.getExpression();
            Expression right = filter.getUpperBoundary();
            String type = "PropertyIsBetween";
            this.start(type);
            mid.accept(this, extraData);
            this.start("LowerBoundary");
            left.accept(this, extraData);
            this.end("LowerBoundary");
            this.start("UpperBoundary");
            right.accept(this, extraData);
            this.end("UpperBoundary");
            this.end(type);
            return extraData;
        }

        @Override
        public Object visit(PropertyIsEqualTo filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "PropertyIsEqualTo";
            this.start("PropertyIsEqualTo");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("PropertyIsEqualTo");
            return extraData;
        }

        @Override
        public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "PropertyIsNotEqualTo";
            this.start("PropertyIsNotEqualTo");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("PropertyIsNotEqualTo");
            return extraData;
        }

        @Override
        public Object visit(PropertyIsGreaterThan filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "PropertyIsGreaterThan";
            this.start("PropertyIsGreaterThan");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("PropertyIsGreaterThan");
            return extraData;
        }

        @Override
        public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "PropertyIsGreaterThanOrEqualTo";
            this.start("PropertyIsGreaterThanOrEqualTo");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("PropertyIsGreaterThanOrEqualTo");
            return extraData;
        }

        @Override
        public Object visit(PropertyIsLessThan filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "PropertyIsLessThan";
            this.start("PropertyIsLessThan");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("PropertyIsLessThan");
            return extraData;
        }

        @Override
        public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "PropertyIsLessThanOrEqualTo";
            this.start("PropertyIsLessThanOrEqualTo");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("PropertyIsLessThanOrEqualTo");
            return extraData;
        }

        @Override
        public Object visit(PropertyIsLike filter, Object extraData) {
            String wcm = filter.getWildCard();
            String wcs = filter.getSingleChar();
            String esc = filter.getEscape();
            Expression expression = filter.getExpression();
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "wildCard", "wildCard", "", wcm);
            atts.addAttribute("", "singleChar", "singleChar", "", wcs);
            atts.addAttribute("", "escape", "escape", "", esc);
            this.start("PropertyIsLike", atts);
            expression.accept(this, extraData);
            this.element("Literal", filter.getLiteral());
            this.end("PropertyIsLike");
            return extraData;
        }

        @Override
        public Object visit(PropertyIsNull filter, Object extraData) {
            Expression expr = filter.getExpression();
            String type = "PropertyIsNull";
            this.start(type);
            expr.accept(this, extraData);
            this.end(type);
            return extraData;
        }

        @Override
        public Object visit(PropertyIsNil filter, Object extraData) {
            Expression expr = filter.getExpression();
            AttributesImpl atts = new AttributesImpl();
            if (filter.getNilReason() != null) {
                atts.addAttribute("", "nilReason", "nilReason", "", filter.getNilReason().toString());
            }
            String type = "PropertyIsNil";
            this.start(type, atts);
            expr.accept(this, extraData);
            this.end(type);
            return extraData;
        }

        @Override
        public Object visit(BBOX filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "BBOX";
            this.start("BBOX");
            left.accept(this, extraData);
            if (right instanceof Literal) {
                Literal literal = (Literal)right;
                Envelope bbox = literal.evaluate(null, Envelope.class);
                if (bbox != null) {
                    this.geometryEncoder.encode(bbox);
                } else {
                    right.accept(this, extraData);
                }
            } else {
                right.accept(this, extraData);
            }
            this.end("BBOX");
            return extraData;
        }

        @Override
        public Object visit(Beyond filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Beyond";
            this.start("Beyond");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.element("Distance", String.valueOf(filter.getDistance()));
            this.element("DistanceUnits", String.valueOf(filter.getDistanceUnits()));
            this.end("Beyond");
            return extraData;
        }

        @Override
        public Object visit(Contains filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Contains";
            this.start("Contains");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("Contains");
            return extraData;
        }

        @Override
        public Object visit(Crosses filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Crosses";
            this.start("Crosses");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("Crosses");
            return extraData;
        }

        @Override
        public Object visit(Disjoint filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Disjoint";
            this.start("Disjoint");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("Disjoint");
            return extraData;
        }

        @Override
        public Object visit(DWithin filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "DWithin";
            this.start("DWithin");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.element("Distance", String.valueOf(filter.getDistance()));
            this.element("DistanceUnits", String.valueOf(filter.getDistanceUnits()));
            this.end("DWithin");
            return extraData;
        }

        @Override
        public Object visit(Equals filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Equals";
            this.start("Equals");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("Equals");
            return extraData;
        }

        @Override
        public Object visit(Intersects filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Intersects";
            this.start("Intersects");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("Intersects");
            return extraData;
        }

        @Override
        public Object visit(Overlaps filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Overlaps";
            this.start("Overlaps");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("Overlaps");
            return extraData;
        }

        @Override
        public Object visit(Touches filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Touches";
            this.start("Touches");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("Touches");
            return extraData;
        }

        @Override
        public Object visit(Within filter, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = "Within";
            this.start("Within");
            left.accept(this, extraData);
            right.accept(this, extraData);
            this.end("Within");
            return extraData;
        }

        @Override
        public Object visitNullFilter(Object extraData) {
            return extraData;
        }

        @Override
        public void encode(Object o) throws IllegalArgumentException {
            if (o instanceof Filter) {
                Filter filter = (Filter)o;
                filter.accept(this, null);
            } else if (o instanceof Expression) {
                Expression expression = (Expression)o;
                expression.accept(this, null);
            } else {
                throw new IllegalArgumentException("Cannot encode " + (o == null ? "null" : o.getClass().getName()) + " should be Filter or Expression");
            }
        }

        @Override
        public Object visit(NilExpression expression, Object extraData) {
            this.element("Literal", "");
            return extraData;
        }

        @Override
        public Object visit(Add expression, Object extraData) {
            String type = "Add";
            this.start(type);
            expression.getExpression1().accept(this, extraData);
            expression.getExpression2().accept(this, extraData);
            this.end(type);
            return extraData;
        }

        @Override
        public Object visit(Divide expression, Object extraData) {
            String type = "Div";
            this.start(type);
            expression.getExpression1().accept(this, extraData);
            expression.getExpression2().accept(this, extraData);
            this.end(type);
            return extraData;
        }

        @Override
        public Object visit(Function expression, Object extraData) {
            String type = "Function";
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", expression.getName());
            this.start(type, atts);
            for (Expression parameter : expression.getParameters()) {
                parameter.accept(this, extraData);
            }
            this.end(type);
            return extraData;
        }

        @Override
        public Object visit(Literal expression, Object extraData) {
            Object value = expression.getValue();
            if (value == null) {
                this.element("Literal", "");
            } else if (value instanceof Geometry) {
                this.geometryEncoder.encode((Geometry)value);
            } else {
                String txt = expression.evaluate(null, String.class);
                if (txt == null) {
                    txt = value.toString();
                }
                this.element("Literal", txt);
            }
            return extraData;
        }

        @Override
        public Object visit(Multiply expression, Object extraData) {
            String type = "Mul";
            this.start(type);
            expression.getExpression1().accept(this, extraData);
            expression.getExpression2().accept(this, extraData);
            this.end(type);
            return extraData;
        }

        @Override
        public Object visit(PropertyName expression, Object extraData) {
            this.element("PropertyName", expression.getPropertyName());
            return extraData;
        }

        @Override
        public Object visit(Subtract expression, Object extraData) {
            String type = "Sub";
            this.start(type);
            expression.getExpression1().accept(this, extraData);
            expression.getExpression2().accept(this, extraData);
            this.end(type);
            return extraData;
        }

        @Override
        public Object visit(After after, Object extraData) {
            return this.visit(after, "After", extraData);
        }

        @Override
        public Object visit(AnyInteracts anyInteracts, Object extraData) {
            return this.visit(anyInteracts, "AnyInteracts", extraData);
        }

        @Override
        public Object visit(Before before, Object extraData) {
            return this.visit(before, "Before", extraData);
        }

        @Override
        public Object visit(Begins begins, Object extraData) {
            return this.visit(begins, "Begins", extraData);
        }

        @Override
        public Object visit(BegunBy begunBy, Object extraData) {
            return this.visit(begunBy, "BegunBy", extraData);
        }

        @Override
        public Object visit(During during, Object extraData) {
            return this.visit(during, "During", extraData);
        }

        @Override
        public Object visit(EndedBy endedBy, Object extraData) {
            return this.visit(endedBy, "EndedBy", extraData);
        }

        @Override
        public Object visit(Ends ends, Object extraData) {
            return this.visit(ends, "Ends", extraData);
        }

        @Override
        public Object visit(Meets meets, Object extraData) {
            return this.visit(meets, "Meets", extraData);
        }

        @Override
        public Object visit(MetBy metBy, Object extraData) {
            return this.visit(metBy, "MetBy", extraData);
        }

        @Override
        public Object visit(OverlappedBy overlappedBy, Object extraData) {
            return this.visit(overlappedBy, "OverlappedBy", extraData);
        }

        @Override
        public Object visit(TContains contains, Object extraData) {
            return this.visit(contains, "TContains", extraData);
        }

        @Override
        public Object visit(TEquals equals, Object extraData) {
            return this.visit(equals, "TEquals", extraData);
        }

        @Override
        public Object visit(TOverlaps contains, Object extraData) {
            return this.visit(contains, "TOverlaps", extraData);
        }

        protected Object visit(BinaryTemporalOperator filter, String name, Object data) {
            this.start(name);
            filter.getExpression1().accept(this, data);
            filter.getExpression2().accept(this, data);
            this.end(name);
            return data;
        }
    }
}

