/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.fixed;

import org.ejml.data.DMatrix2;
import org.ejml.data.DMatrix2x2;
import org.ejml.dense.fixed.CommonOps_DDF2;

public class NormOps_DDF2 {
    public static void normalizeF(DMatrix2x2 M2) {
        double val = NormOps_DDF2.normF(M2);
        CommonOps_DDF2.divide(M2, val);
    }

    public static void normalizeF(DMatrix2 M2) {
        double val = NormOps_DDF2.normF(M2);
        CommonOps_DDF2.divide(M2, val);
    }

    public static double fastNormF(DMatrix2x2 M2) {
        double sum = 0.0;
        sum += M2.a11 * M2.a11 + M2.a12 * M2.a12;
        return Math.sqrt(sum += M2.a21 * M2.a21 + M2.a22 * M2.a22);
    }

    public static double fastNormF(DMatrix2 M2) {
        double sum = M2.a1 * M2.a1 + M2.a2 * M2.a2;
        return Math.sqrt(sum);
    }

    public static double normF(DMatrix2x2 M2) {
        double scale = CommonOps_DDF2.elementMaxAbs(M2);
        if (scale == 0.0) {
            return 0.0;
        }
        double a11 = M2.a11 / scale;
        double a12 = M2.a12 / scale;
        double a21 = M2.a21 / scale;
        double a22 = M2.a22 / scale;
        double sum = 0.0;
        sum += a11 * a11 + a12 * a12;
        return scale * Math.sqrt(sum += a21 * a21 + a22 * a22);
    }

    public static double normF(DMatrix2 M2) {
        double scale = CommonOps_DDF2.elementMaxAbs(M2);
        if (scale == 0.0) {
            return 0.0;
        }
        double a1 = M2.a1 / scale;
        double a2 = M2.a2 / scale;
        double sum = a1 * a1 + a2 * a2;
        return scale * Math.sqrt(sum);
    }
}

