/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.BreakInstr;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.XSLBreakOrContinue;
import net.sf.saxon.trans.XPathException;

public class XSLBreak
extends XSLBreakOrContinue {
    private Expression select;

    @Override
    public void prepareAttributes() throws XPathException {
        String selectAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
    }

    @Override
    protected boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.validatePosition();
        if (this.xslIterate == null) {
            this.compileError(this.getDisplayName() + " must be a descendant of an xsl:iterate instruction", "XTSE3120");
        }
        if (this.select != null && this.iterateAxis((byte)3).next() != null) {
            this.compileError("An xsl:break element with a select attribute must be empty", "XTSE3125");
        }
        this.select = this.typeCheck("select", this.select);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression val = this.select;
        if (val == null) {
            val = this.compileSequenceConstructor(exec, decl, false);
        }
        BreakInstr brake = new BreakInstr();
        brake.setRetainedStaticContext(this.makeRetainedStaticContext());
        return Block.makeBlock(val, brake);
    }
}

