/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.algorithm.jgit;

import com.github.difflib.algorithm.Change;
import com.github.difflib.algorithm.DiffAlgorithmI;
import com.github.difflib.algorithm.DiffAlgorithmListener;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.algorithm.jgit.DataList;
import com.github.difflib.algorithm.jgit.DataListComparator;
import com.github.difflib.patch.DeltaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;

public class HistogramDiff<T>
implements DiffAlgorithmI<T> {
    @Override
    public List<Change> computeDiff(List<T> source, List<T> target, DiffAlgorithmListener progress) throws DiffException {
        Objects.requireNonNull(source, "source list must not be null");
        Objects.requireNonNull(target, "target list must not be null");
        if (progress != null) {
            progress.diffStart();
        }
        EditList diffList = new EditList();
        diffList.addAll(new org.eclipse.jgit.diff.HistogramDiff().diff(new DataListComparator(progress), new DataList<T>(source), new DataList<T>(target)));
        ArrayList<Change> patch = new ArrayList<Change>();
        for (Edit edit : diffList) {
            DeltaType type = DeltaType.EQUAL;
            switch (edit.getType()) {
                case DELETE: {
                    type = DeltaType.DELETE;
                    break;
                }
                case INSERT: {
                    type = DeltaType.INSERT;
                    break;
                }
                case REPLACE: {
                    type = DeltaType.CHANGE;
                }
            }
            patch.add(new Change(type, edit.getBeginA(), edit.getEndA(), edit.getBeginB(), edit.getEndB()));
        }
        if (progress != null) {
            progress.diffEnd();
        }
        return patch;
    }
}

