/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib;

import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.Patch;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UnifiedDiffUtils {
    private static final Pattern UNIFIED_DIFF_CHUNK_REGEXP = Pattern.compile("^@@\\s+-(?:(\\d+)(?:,(\\d+))?)\\s+\\+(?:(\\d+)(?:,(\\d+))?)\\s+@@$");

    public static Patch<String> parseUnifiedDiff(List<String> diff) {
        String rest;
        String tag;
        boolean inPrelude = true;
        ArrayList<String[]> rawChunk = new ArrayList<String[]>();
        Patch<String> patch = new Patch<String>();
        int old_ln = 0;
        int new_ln = 0;
        for (String line : diff) {
            if (inPrelude) {
                if (!line.startsWith("+++")) continue;
                inPrelude = false;
                continue;
            }
            Matcher m3 = UNIFIED_DIFF_CHUNK_REGEXP.matcher(line);
            if (m3.find()) {
                if (!rawChunk.isEmpty()) {
                    ArrayList<String> oldChunkLines = new ArrayList<String>();
                    ArrayList<String> newChunkLines = new ArrayList<String>();
                    for (String[] raw_line : rawChunk) {
                        tag = raw_line[0];
                        rest = raw_line[1];
                        if (" ".equals(tag) || "-".equals(tag)) {
                            oldChunkLines.add(rest);
                        }
                        if (!" ".equals(tag) && !"+".equals(tag)) continue;
                        newChunkLines.add(rest);
                    }
                    patch.addDelta(new ChangeDelta(new Chunk(old_ln - 1, oldChunkLines), new Chunk(new_ln - 1, newChunkLines)));
                    rawChunk.clear();
                }
                old_ln = m3.group(1) == null ? 1 : Integer.parseInt(m3.group(1));
                int n = new_ln = m3.group(3) == null ? 1 : Integer.parseInt(m3.group(3));
                if (old_ln == 0) {
                    ++old_ln;
                }
                if (new_ln != 0) continue;
                ++new_ln;
                continue;
            }
            if (line.length() > 0) {
                tag = line.substring(0, 1);
                rest = line.substring(1);
                if (!" ".equals(tag) && !"+".equals(tag) && !"-".equals(tag)) continue;
                rawChunk.add(new String[]{tag, rest});
                continue;
            }
            rawChunk.add(new String[]{" ", ""});
        }
        if (!rawChunk.isEmpty()) {
            ArrayList<String> oldChunkLines = new ArrayList<String>();
            ArrayList<String> newChunkLines = new ArrayList<String>();
            for (String[] raw_line : rawChunk) {
                tag = raw_line[0];
                rest = raw_line[1];
                if (" ".equals(tag) || "-".equals(tag)) {
                    oldChunkLines.add(rest);
                }
                if (!" ".equals(tag) && !"+".equals(tag)) continue;
                newChunkLines.add(rest);
            }
            patch.addDelta(new ChangeDelta(new Chunk(old_ln - 1, oldChunkLines), new Chunk(new_ln - 1, newChunkLines)));
            rawChunk.clear();
        }
        return patch;
    }

    public static List<String> generateUnifiedDiff(String originalFileName, String revisedFileName, List<String> originalLines, Patch<String> patch, int contextSize) {
        if (!patch.getDeltas().isEmpty()) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("--- " + originalFileName);
            ret.add("+++ " + revisedFileName);
            ArrayList<AbstractDelta<String>> patchDeltas = new ArrayList<AbstractDelta<String>>(patch.getDeltas());
            ArrayList<AbstractDelta<String>> deltas = new ArrayList<AbstractDelta<String>>();
            AbstractDelta delta = (AbstractDelta)patchDeltas.get(0);
            deltas.add(delta);
            if (patchDeltas.size() > 1) {
                for (int i = 1; i < patchDeltas.size(); ++i) {
                    int position = delta.getSource().getPosition();
                    AbstractDelta nextDelta = (AbstractDelta)patchDeltas.get(i);
                    if (position + delta.getSource().size() + contextSize >= nextDelta.getSource().getPosition() - contextSize) {
                        deltas.add(nextDelta);
                    } else {
                        List<String> curBlock = UnifiedDiffUtils.processDeltas(originalLines, deltas, contextSize);
                        ret.addAll(curBlock);
                        deltas.clear();
                        deltas.add(nextDelta);
                    }
                    delta = nextDelta;
                }
            }
            List<String> curBlock = UnifiedDiffUtils.processDeltas(originalLines, deltas, contextSize);
            ret.addAll(curBlock);
            return ret;
        }
        return new ArrayList<String>();
    }

    private static List<String> processDeltas(List<String> origLines, List<AbstractDelta<String>> deltas, int contextSize) {
        int line;
        int contextStart;
        int revStart;
        ArrayList<String> buffer = new ArrayList<String>();
        int origTotal = 0;
        int revTotal = 0;
        AbstractDelta<String> curDelta = deltas.get(0);
        int origStart = curDelta.getSource().getPosition() + 1 - contextSize;
        if (origStart < 1) {
            origStart = 1;
        }
        if ((revStart = curDelta.getTarget().getPosition() + 1 - contextSize) < 1) {
            revStart = 1;
        }
        if ((contextStart = curDelta.getSource().getPosition() - contextSize) < 0) {
            contextStart = 0;
        }
        for (line = contextStart; line < curDelta.getSource().getPosition(); ++line) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
        }
        buffer.addAll(UnifiedDiffUtils.getDeltaText(curDelta));
        origTotal += curDelta.getSource().getLines().size();
        revTotal += curDelta.getTarget().getLines().size();
        for (int deltaIndex = 1; deltaIndex < deltas.size(); ++deltaIndex) {
            int intermediateStart;
            AbstractDelta<String> nextDelta = deltas.get(deltaIndex);
            for (line = intermediateStart = curDelta.getSource().getPosition() + curDelta.getSource().getLines().size(); line < nextDelta.getSource().getPosition(); ++line) {
                buffer.add(" " + origLines.get(line));
                ++origTotal;
                ++revTotal;
            }
            buffer.addAll(UnifiedDiffUtils.getDeltaText(nextDelta));
            origTotal += nextDelta.getSource().getLines().size();
            revTotal += nextDelta.getTarget().getLines().size();
            curDelta = nextDelta;
        }
        for (line = contextStart = curDelta.getSource().getPosition() + curDelta.getSource().getLines().size(); line < contextStart + contextSize && line < origLines.size(); ++line) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
        }
        StringBuilder header = new StringBuilder();
        header.append("@@ -");
        header.append(origStart);
        header.append(",");
        header.append(origTotal);
        header.append(" +");
        header.append(revStart);
        header.append(",");
        header.append(revTotal);
        header.append(" @@");
        buffer.add(0, header.toString());
        return buffer;
    }

    private static List<String> getDeltaText(AbstractDelta<String> delta) {
        ArrayList<String> buffer = new ArrayList<String>();
        for (String line : delta.getSource().getLines()) {
            buffer.add("-" + line);
        }
        for (String line : delta.getTarget().getLines()) {
            buffer.add("+" + line);
        }
        return buffer;
    }

    private UnifiedDiffUtils() {
    }
}

