/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.points;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class DuplicateLocationInPolyLineCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Repeated location found at {0} for feature id {1,number,#} ");
    private static final long serialVersionUID = 7403488805532662065L;

    public DuplicateLocationInPolyLineCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge || object instanceof Area || object instanceof Line;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        HashSet<Location> visitedLocations = new HashSet<Location>();
        for (Location currentLocation : ((AtlasItem)object).getRawGeometry()) {
            if (visitedLocations.contains(currentLocation) && !this.isFlagged(object.getOsmIdentifier())) {
                this.markAsFlagged(object.getOsmIdentifier());
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, currentLocation.toString(), object.getIdentifier())));
            }
            visitedLocations.add(currentLocation);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

