/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.IntersectionUtilities;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LevelTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class LineCrossingWaterBodyCheck
extends BaseCheck<Long> {
    private static final String LINEAR_INSTRUCTION = "Linear item {0,number,#} is crossing water body invalidly.";
    private static final String BUILDING_INSTRUCTION = "Building item {0,number,#} is intersecting water body invalidly.";
    private static final String WATERBODY_INSTRUCTION = "The water body with id {0,number,#} has invalid crossings.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The water body with id {0,number,#} has invalid crossings.", "Linear item {0,number,#} is crossing water body invalidly.", "Building item {0,number,#} is intersecting water body invalidly.");
    private static final String ADDRESS_PREFIX_KEY = "addr";
    private static final Set<String> VALID_LINE_TAGS = Stream.of("notes", "source", "natural", "place", "admin_level").collect(Collectors.toSet());
    private static final TaggableFilter VALID_RELATIONS_TAG_FILTER = TaggableFilter.forDefinition((String)"natural->*|place->*|landuse->*|waterway->*|admin_level->*|boundary->*");
    private static final String DEFAULT_CAN_CROSS_WATER_BODY_TAGS = "waterway->*|boundary->*|landuse->*|bridge->yes,viaduct,aqueduct,boardwalk,covered,low_water_crossing,movable,suspension|tunnel->yes,culvert,building_passage|embankment->yes|location->underwater,underground|power->line,minor_line|man_made->pier,breakwater,embankment,groyne,dyke,pipeline|route->ferry|highway->proposed,construction|ice_road->yes|ford->yes|winter_road->yes|snowmobile->yes|ski->yes";
    private TaggableFilter canCrossWaterBodyFilter;
    private TaggableFilter lineItemsOffending;
    private boolean flagBuildings;
    private static final String DEFAULT_HIGHWAY_MINIMUM = "TOLL_GANTRY";
    private HighwayTag highwayMinimum;
    private static final List<String> DEFAULT_HIGHWAYS_EXCLUDE = Collections.emptyList();
    private List<HighwayTag> highwaysExclude;
    private static final String BUILDING_TAGS_DO_NOT_FLAG = "public_transport->station,aerialway=station";
    private static final TaggableFilter NONOFFENDING_BUILDINGS = TaggableFilter.forDefinition((String)"public_transport->station,aerialway=station");
    private static final String WATER_BODY_TAGS = "natural->spring,hot_spring&name->*|natural->lake,pond|water:type->lake|landuse->pond|water->lake,pond,oxbow,salt_lake|natural->stream|water->canal,river,lock,moat,riverbank,creek,stream,stream_pool|waterway->river,riverbank,brook,ditch,stream,creek,canal,derelict_canal|stream->*|waterway->drain&name->*|water->drain&name->*|water->reservoir|water->dam&natural->water|landuse->reservoir|natural->reservoir|seamark:type->dam&natural->water|natural->water|waterway->water|water->water,perennial|landuse->water|wetland->tidalflat,reedbed|water->tidalflat,reedbed|natural->tidalflat,reedbed|natural->lagoon|water->lagoon|waterway->lagoon|intermittent->dry|seasonal->dry|natural->dry_lake|waterway->billabong,navigablechannel,river;stream,reservoir";
    private static final TaggableFilter VALID_WATER_BODY_TAGS = TaggableFilter.forDefinition((String)"natural->spring,hot_spring&name->*|natural->lake,pond|water:type->lake|landuse->pond|water->lake,pond,oxbow,salt_lake|natural->stream|water->canal,river,lock,moat,riverbank,creek,stream,stream_pool|waterway->river,riverbank,brook,ditch,stream,creek,canal,derelict_canal|stream->*|waterway->drain&name->*|water->drain&name->*|water->reservoir|water->dam&natural->water|landuse->reservoir|natural->reservoir|seamark:type->dam&natural->water|natural->water|waterway->water|water->water,perennial|landuse->water|wetland->tidalflat,reedbed|water->tidalflat,reedbed|natural->tidalflat,reedbed|natural->lagoon|water->lagoon|waterway->lagoon|intermittent->dry|seasonal->dry|natural->dry_lake|waterway->billabong,navigablechannel,river;stream,reservoir");
    private static final String WATER_BODY_EXCLUDE_TAGS = "natural->dock,water_point,floodway,spillway,wastewater,waterhole|waterway->lock_gate,dock,water_point,floodway,spillway,wastewater,waterhole,culvert,dam,waterfall,fish_pass,dry_dock,construction,boat_lift,weir,breakwater,boatyard|water->lock_gate,dock,water_point,floodway,spillway,wastewater,waterhole,pool,reflecting_pool,swimming_pool,salt_pool,fountain,tank,fish_pass|tunnel->culvert|waterway->drain&name->!|water->drain&name->!|wetland->tidalflat,reedbed&seasonal->yes|water->tidalflat,reedbed&seasonal->yes|natural->tidalflat,reedbed&seasonal->yes|covered->yes|highway->*|natural->strait,channel,fjord,sound,bay|harbour->*&harbour->!no|estuary->*&estuary->!no|bay->*&bay->!no|seamark:type->harbour,harbour_basin,sea_area|place->sea|water->bay,cove,harbour|waterway->artificial,dock|man_made->breakwater,pier|natural->beach,marsh,swamp|water->marsh|wetland->bog,fen,mangrove,marsh,saltern,saltmarsh,string_bog,swamp,wet_meadow|waterway->drainage_channel,glacier,Minnow Falls, pumping_station|water->tank,Earth_Tank_,_Off_Stream_Flow_Dam,treatment_pond,re#,swamp_-_occasional,trough,Trough,waste_water";
    private static final TaggableFilter INVALID_WATER_BODY_TAGS = TaggableFilter.forDefinition((String)"natural->dock,water_point,floodway,spillway,wastewater,waterhole|waterway->lock_gate,dock,water_point,floodway,spillway,wastewater,waterhole,culvert,dam,waterfall,fish_pass,dry_dock,construction,boat_lift,weir,breakwater,boatyard|water->lock_gate,dock,water_point,floodway,spillway,wastewater,waterhole,pool,reflecting_pool,swimming_pool,salt_pool,fountain,tank,fish_pass|tunnel->culvert|waterway->drain&name->!|water->drain&name->!|wetland->tidalflat,reedbed&seasonal->yes|water->tidalflat,reedbed&seasonal->yes|natural->tidalflat,reedbed&seasonal->yes|covered->yes|highway->*|natural->strait,channel,fjord,sound,bay|harbour->*&harbour->!no|estuary->*&estuary->!no|bay->*&bay->!no|seamark:type->harbour,harbour_basin,sea_area|place->sea|water->bay,cove,harbour|waterway->artificial,dock|man_made->breakwater,pier|natural->beach,marsh,swamp|water->marsh|wetland->bog,fen,mangrove,marsh,saltern,saltmarsh,string_bog,swamp,wet_meadow|waterway->drainage_channel,glacier,Minnow Falls, pumping_station|water->tank,Earth_Tank_,_Off_Stream_Flow_Dam,treatment_pond,re#,swamp_-_occasional,trough,Trough,waste_water");
    private static final long serialVersionUID = 6048659185833217159L;

    private static boolean canRelationCrossWaterBody(Set<Relation> multipolygonRelations) {
        return multipolygonRelations.stream().anyMatch(VALID_RELATIONS_TAG_FILTER);
    }

    private static boolean hasOnlyValidCrossingTags(Map<String, String> osmTags) {
        Validators validators = new Validators(Taggable.class);
        Set<String> keySet = osmTags.keySet();
        return keySet.stream().filter(arg_0 -> ((Validators)validators).canValidate(arg_0)).count() == keySet.stream().filter(VALID_LINE_TAGS::contains).count();
    }

    private static boolean isBoundary(AtlasEntity crossingLine) {
        Map osmTags = crossingLine.getOsmTags();
        Set relations = crossingLine.relations();
        Set<Relation> multipolygonRelations = relations.stream().filter(Relation::isMultiPolygon).collect(Collectors.toSet());
        return osmTags.isEmpty() && relations.isEmpty() || LineCrossingWaterBodyCheck.canRelationCrossWaterBody(multipolygonRelations) || multipolygonRelations.isEmpty() && LineCrossingWaterBodyCheck.hasOnlyValidCrossingTags(osmTags);
    }

    public LineCrossingWaterBodyCheck(Configuration configuration) {
        super(configuration);
        this.lineItemsOffending = TaggableFilter.forDefinition((String)this.configurationValue(configuration, "lineItems.offending", ""));
        this.flagBuildings = this.configurationValue(configuration, "buildings.flag", false);
        this.canCrossWaterBodyFilter = TaggableFilter.forDefinition((String)this.configurationValue(configuration, "lineItems.non_offending", DEFAULT_CAN_CROSS_WATER_BODY_TAGS));
        this.highwayMinimum = Enum.valueOf(HighwayTag.class, this.configurationValue(configuration, "highway.minimum", DEFAULT_HIGHWAY_MINIMUM).toUpperCase());
        this.highwaysExclude = this.configurationValue(configuration, "highways.exclude", DEFAULT_HIGHWAYS_EXCLUDE).stream().map(element -> Enum.valueOf(HighwayTag.class, element.toUpperCase())).collect(Collectors.toList());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TypePredicates.IS_AREA.test(object) && !INVALID_WATER_BODY_TAGS.test((Taggable)object) && VALID_WATER_BODY_TAGS.test((Taggable)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Area objectAsArea = (Area)object;
        Polygon areaAsPolygon = objectAsArea.asPolygon();
        Atlas atlas = object.getAtlas();
        MultiIterable allCrossingItems = this.flagBuildings ? new MultiIterable(new Iterable[]{atlas.lineItemsIntersecting((GeometricSurface)areaAsPolygon, lineItem -> this.isOffendingLineItem(object, areaAsPolygon).test((LineItem)lineItem)), atlas.areasIntersecting((GeometricSurface)areaAsPolygon, area -> BuildingTag.isBuilding((Taggable)area) && !NONOFFENDING_BUILDINGS.test((Taggable)area) && LevelTag.areOnSameLevel((Taggable)object, (Taggable)area))}) : new MultiIterable(new Iterable[]{atlas.lineItemsIntersecting((GeometricSurface)areaAsPolygon, lineItem -> this.isOffendingLineItem(object, areaAsPolygon).test((LineItem)lineItem))});
        boolean hasInvalidCrossings = false;
        CheckFlag newFlag = new CheckFlag(this.getTaskIdentifier(object));
        newFlag.addObject(object);
        newFlag.addInstruction(this.getLocalizedInstruction(0, object.getOsmIdentifier()));
        for (AtlasItem crossingItem : allCrossingItems) {
            if (!(crossingItem instanceof Area) && (this.canCrossWaterBody(crossingItem) || IntersectionUtilities.haveExplicitLocationsForIntersections(areaAsPolygon, (LineItem)crossingItem))) continue;
            newFlag.addObject((AtlasObject)crossingItem);
            newFlag.addInstruction(this.getLocalizedInstruction(crossingItem instanceof Area ? 2 : 1, crossingItem.getOsmIdentifier()));
            hasInvalidCrossings = true;
        }
        if (hasInvalidCrossings) {
            return Optional.of(newFlag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean canCrossWaterBody(AtlasItem crossingItem) {
        return this.canCrossWaterBodyFilter.test((Taggable)crossingItem) || crossingItem.containsKeyStartsWith(Collections.singleton(ADDRESS_PREFIX_KEY)) || crossingItem instanceof Line && LineCrossingWaterBodyCheck.isBoundary((AtlasEntity)crossingItem);
    }

    private Predicate<LineItem> isOffendingLineItem(AtlasObject object, Polygon areaAsPolygon) {
        return lineItem -> (lineItem instanceof Edge && ((Edge)lineItem).highwayTag().isMoreImportantThanOrEqualTo(this.highwayMinimum) && !this.highwaysExclude.contains(((Edge)lineItem).highwayTag()) || this.lineItemsOffending.test((Taggable)lineItem)) && lineItem.intersects((GeometricSurface)areaAsPolygon) && (!Validators.hasValuesFor((Taggable)lineItem, (Class[])new Class[]{BridgeTag.class}) || Validators.isOfType((Taggable)lineItem, BridgeTag.class, (Enum[])new BridgeTag[]{BridgeTag.NO})) && LevelTag.areOnSameLevel((Taggable)object, (Taggable)lineItem);
    }
}

