/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.atlas.walker.SimpleEdgeWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.LevelTag;
import org.openstreetmap.atlas.tags.OneWayTag;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.direction.EdgeDirectionComparator;
import org.openstreetmap.atlas.utilities.scalars.Angle;

public class AtGradeSignPostCheck
extends BaseCheck<String> {
    private static final long serialVersionUID = -7428641176420422187L;
    private static final List<String> CONNECTIONS_TO_PRIMARY = Arrays.asList("trunk", "primary", "secondary");
    private static final List<String> CONNECTIONS_TO_TRUNK = Collections.singletonList("primary");
    private static final List<String> CONNECTIONS_TO_SECONDARY = Collections.singletonList("primary");
    private static final ImmutableMap<String, List<String>> CONNECTED_HIGHWAY_TYPES_MAP = ImmutableMap.of((Object)"primary", CONNECTIONS_TO_PRIMARY, (Object)"trunk", CONNECTIONS_TO_TRUNK, (Object)"secondary", CONNECTIONS_TO_SECONDARY);
    private static final String NO_DESTINATION_SIGN_RELATION_INSTRUCTION = "Node {0,number,#} forms an at-grade junction but is not part of a destination sign relation. Verify and create a destination sign relation with the node as \"intersection\" member and following connected edges {1}, as \"to\" and \"from\" members.";
    private static final String DESTINATION_SIGN_RELATION_MISSING_DESTINATION_TAG_INSTRUCTION = "Node {0,number,#} form an at-grade junction. It is part of destination sign relation(s): {1}but the relation(s) are missing \"destination\" tags.";
    private static final String INCOMPLETE_DESTINATION_RELATION_INSTRUCTION = "Node {0,number,#} forms an at-grade junction and is part of destination sign relation(s). But the following connected edges {1} could also form destination sign relations with this node. Create new destination sign relation with these edges and the node.";
    private static final String ROUNDABOUT_EDGE_MISSING_DESTINATION_SIGN_RELATION = "Node {0,number,#} is part of a roundabout and forms an at-grade junction with connected edges. Add destination sign relations with the node as \"intersection\" member and following connected edges {1}, as \"to\" and \"from\" members and add destination sign tag to the connected edges.";
    private static final String ROUNDABOUT_EDGE_INCOMPLETE_DESTINATION_SIGN_RELATION = "Node {0,number,#} is part of a roundabout and forms an at-grade junction. It is part of destination sign relation(s). Either the existing relations are missing destination sign tag or following connected edges {1} could also form destination sign relations with this node. Either add destination tags to existing relations or create new destination sign relation with these edges and the node.";
    private static final String NON_ROUNDABOUT_INTERSECTION_MAP = "nonRoundaboutMatchingEdgesMap";
    private static final String ROUNDABOUT_INTERSECTION_MAP = "roundaboutMatchingEdgesMap";
    private static final int INSTRUCTION_INDEX_ZERO = 0;
    private static final int INSTRUCTION_INDEX_ONE = 1;
    private static final int INSTRUCTION_INDEX_TWO = 2;
    private static final int INSTRUCTION_INDEX_THREE = 3;
    private static final int INSTRUCTION_INDEX_FOUR = 4;
    private static final int MINIMUM_NODE_VALENCE = 3;
    private static final Angle DEFAULT_OPPOSITE_DIRECTION_LOWER_LIMIT = Angle.degrees((double)171.0);
    private static final Angle DEFAULT_OPPOSITE_DIRECTION_UPPER_LIMIT = Angle.degrees((double)-171.0);
    private static final Angle DEFAULT_SAME_DIRECTION_LOWER_LIMIT = Angle.degrees((double)-100.0);
    private static final Angle DEFAULT_SAME_DIRECTION_UPPER_LIMIT = Angle.degrees((double)9.0);
    private static final EdgeDirectionComparator EDGE_DIRECTION_COMPARATOR = new EdgeDirectionComparator(DEFAULT_OPPOSITE_DIRECTION_LOWER_LIMIT, DEFAULT_OPPOSITE_DIRECTION_UPPER_LIMIT, DEFAULT_SAME_DIRECTION_LOWER_LIMIT, DEFAULT_SAME_DIRECTION_UPPER_LIMIT);
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Node {0,number,#} forms an at-grade junction but is not part of a destination sign relation. Verify and create a destination sign relation with the node as \"intersection\" member and following connected edges {1}, as \"to\" and \"from\" members.", "Node {0,number,#} form an at-grade junction. It is part of destination sign relation(s): {1}but the relation(s) are missing \"destination\" tags.", "Node {0,number,#} forms an at-grade junction and is part of destination sign relation(s). But the following connected edges {1} could also form destination sign relations with this node. Create new destination sign relation with these edges and the node.", "Node {0,number,#} is part of a roundabout and forms an at-grade junction with connected edges. Add destination sign relations with the node as \"intersection\" member and following connected edges {1}, as \"to\" and \"from\" members and add destination sign tag to the connected edges.", "Node {0,number,#} is part of a roundabout and forms an at-grade junction. It is part of destination sign relation(s). Either the existing relations are missing destination sign tag or following connected edges {1} could also form destination sign relations with this node. Either add destination tags to existing relations or create new destination sign relation with these edges and the node.");
    private final Set<String> highwayFilter;
    private Map<String, List<String>> connectedHighwayTypes;

    public AtGradeSignPostCheck(Configuration configuration) {
        super(configuration);
        this.connectedHighwayTypes = (Map)this.configurationValue(configuration, "connected.highway.types", CONNECTED_HIGHWAY_TYPES_MAP);
        this.highwayFilter = new HashSet<String>(this.connectedHighwayTypes.keySet());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Node && ((Node)object).valence() >= 3L && !this.isFlagged(String.valueOf(object.getIdentifier()));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Node intersectingNode = (Node)object;
        List<Edge> inEdges = intersectingNode.inEdges().stream().filter(this::isValidIntersectingEdge).sorted(Comparator.comparingLong(AtlasObject::getIdentifier)).collect(Collectors.toList());
        Set<Edge> outEdges = intersectingNode.outEdges().stream().filter(this::isValidIntersectingEdge).collect(Collectors.toSet());
        if (inEdges.isEmpty() || outEdges.size() < 2) {
            return Optional.empty();
        }
        Map<String, Map<AtlasEntity, Set<AtlasEntity>>> mapOfMatchingInAndOutEdges = this.populateInEdgeToOutEdgeMaps(inEdges, outEdges);
        Map<AtlasEntity, Set<AtlasEntity>> nonRoundaboutInEdgeToOutEdgeMap = mapOfMatchingInAndOutEdges.get(NON_ROUNDABOUT_INTERSECTION_MAP);
        Map<AtlasEntity, Set<AtlasEntity>> roundAboutInEdgeToOutEdgeMap = mapOfMatchingInAndOutEdges.get(ROUNDABOUT_INTERSECTION_MAP);
        if ((nonRoundaboutInEdgeToOutEdgeMap == null || nonRoundaboutInEdgeToOutEdgeMap.isEmpty()) && (roundAboutInEdgeToOutEdgeMap == null || roundAboutInEdgeToOutEdgeMap.isEmpty())) {
            return Optional.empty();
        }
        Optional<Set<Relation>> destinationSignRelations = this.getParentDestinationSignRelations((AtlasEntity)intersectingNode);
        FlaggedIntersection flaggedIntersection = destinationSignRelations.isEmpty() ? this.getFlaggedIntersection(roundAboutInEdgeToOutEdgeMap, nonRoundaboutInEdgeToOutEdgeMap) : this.getIntersectionsWithIncompleteDestinationSignRelation(roundAboutInEdgeToOutEdgeMap, nonRoundaboutInEdgeToOutEdgeMap, intersectingNode, destinationSignRelations.get());
        int instructionIndex = flaggedIntersection.getInstructionIndex();
        if (instructionIndex == -1) {
            return Optional.empty();
        }
        Set<AtlasEntity> entitiesToBeFlagged = flaggedIntersection.getFlaggedItems();
        List<String> identifiers = this.getIdentifiers(entitiesToBeFlagged);
        entitiesToBeFlagged.add((AtlasEntity)intersectingNode);
        this.markAsFlagged(String.valueOf(intersectingNode.getIdentifier()));
        return Optional.of(this.createFlag(entitiesToBeFlagged, this.getLocalizedInstruction(instructionIndex, intersectingNode.getIdentifier(), new StringList(identifiers).join(", "))));
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Optional<Set<AtlasEntity>> connectedEdgesNotPartOfRelation(AtlasEntity fromEdge, Set<AtlasEntity> toEdges, Set<Relation> destinationSignRelations) {
        HashSet<AtlasEntity> outEdges = new HashSet<AtlasEntity>(toEdges);
        Set filteredOutEdges = outEdges.stream().filter(outEdge -> this.isMissingDestinationTag((Edge)outEdge)).collect(Collectors.toSet());
        Set<AtlasEntity> allRelationMembers = destinationSignRelations.stream().flatMap(destinationSignRelation -> {
            RelationMemberList relationMembers = destinationSignRelation.allKnownOsmMembers();
            return relationMembers.stream().map(RelationMember::getEntity);
        }).collect(Collectors.toSet());
        if (!allRelationMembers.contains(fromEdge)) {
            filteredOutEdges.add(fromEdge);
            return Optional.of(filteredOutEdges);
        }
        allRelationMembers.forEach(filteredOutEdges::remove);
        if (!filteredOutEdges.isEmpty()) {
            filteredOutEdges.add(fromEdge);
            return Optional.of(filteredOutEdges);
        }
        return Optional.empty();
    }

    private Set<AtlasEntity> getAllRoundaboutEdgesMissingTagsOrRelations(Map<AtlasEntity, Set<AtlasEntity>> roundAboutInEdgeToOutEdgeMap, Set<Relation> destinationSignRelations) {
        HashSet<AtlasEntity> entitiesToBeFlagged = new HashSet<AtlasEntity>();
        roundAboutInEdgeToOutEdgeMap.forEach((inEdge, setOfOutEdge) -> {
            Optional<AtlasEntity> roundaboutEdge = setOfOutEdge.stream().filter(JunctionTag::isRoundabout).findFirst();
            Optional<AtlasEntity> roundaboutExitEdge = setOfOutEdge.stream().filter(outEdge -> !JunctionTag.isRoundabout((Taggable)outEdge)).findFirst();
            if (roundaboutEdge.isPresent() && roundaboutExitEdge.isPresent()) {
                Set<AtlasEntity> roundaboutEdges = this.getRoundaboutEdges((Edge)roundaboutEdge.get());
                AtlasEntity exitEdge = roundaboutExitEdge.get();
                if (this.isMissingDestinationTag((Edge)exitEdge)) {
                    entitiesToBeFlagged.addAll(roundaboutEdges);
                    entitiesToBeFlagged.add(roundaboutExitEdge.get());
                }
                Optional<Set<AtlasEntity>> roundAboutEdgesNotPartOfRelations = this.connectedEdgesNotPartOfRelation(exitEdge, roundaboutEdges, destinationSignRelations);
                roundAboutEdgesNotPartOfRelations.ifPresent(entitiesToBeFlagged::addAll);
            }
        });
        return entitiesToBeFlagged;
    }

    private Set<AtlasEntity> getConnectedEdgesNotFormDestinationRelation(Map<AtlasEntity, Set<AtlasEntity>> nonRoundaboutInEdgeToOutEdgeMap, Set<Relation> destinationSignRelations) {
        return nonRoundaboutInEdgeToOutEdgeMap.entrySet().stream().flatMap(atlasEntitySetEntry -> {
            AtlasEntity key = (AtlasEntity)atlasEntitySetEntry.getKey();
            return this.connectedEdgesNotPartOfRelation(key, (Set)nonRoundaboutInEdgeToOutEdgeMap.get(key), destinationSignRelations).stream();
        }).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private FlaggedIntersection getFlaggedIntersection(Map<AtlasEntity, Set<AtlasEntity>> roundAboutInEdgeToOutEdgeMap, Map<AtlasEntity, Set<AtlasEntity>> nonRoundaboutInEdgeToOutEdgeMap) {
        HashSet<AtlasEntity> entitiesToBeFlagged = new HashSet<AtlasEntity>();
        int instructionIndex = -1;
        if (roundAboutInEdgeToOutEdgeMap.isEmpty() && nonRoundaboutInEdgeToOutEdgeMap != null) {
            nonRoundaboutInEdgeToOutEdgeMap.forEach((inEdge, setOfOutEdge) -> {
                entitiesToBeFlagged.add((AtlasEntity)inEdge);
                entitiesToBeFlagged.addAll((Collection<AtlasEntity>)setOfOutEdge);
            });
            if (!entitiesToBeFlagged.isEmpty()) {
                instructionIndex = 0;
            }
        } else {
            roundAboutInEdgeToOutEdgeMap.forEach((inEdge, setOfOutEdge) -> {
                Optional<AtlasEntity> roundaboutEdge = JunctionTag.isRoundabout((Taggable)inEdge) ? Optional.of(inEdge) : setOfOutEdge.stream().filter(JunctionTag::isRoundabout).findFirst();
                Optional<AtlasEntity> roundaboutExitEdge = setOfOutEdge.stream().filter(outEdge -> !JunctionTag.isRoundabout((Taggable)outEdge)).findFirst();
                if (roundaboutEdge.isPresent() && roundaboutExitEdge.isPresent()) {
                    entitiesToBeFlagged.addAll(this.getRoundaboutEdges((Edge)roundaboutEdge.get()));
                    entitiesToBeFlagged.add(roundaboutExitEdge.get());
                }
            });
            if (!entitiesToBeFlagged.isEmpty()) {
                instructionIndex = 3;
            }
        }
        return new FlaggedIntersection(instructionIndex, entitiesToBeFlagged);
    }

    private List<String> getIdentifiers(Set<AtlasEntity> objects) {
        return Iterables.stream(objects).map(AtlasObject::getIdentifier).map(String::valueOf).collectToList();
    }

    private FlaggedIntersection getIntersectionsWithIncompleteDestinationSignRelation(Map<AtlasEntity, Set<AtlasEntity>> roundAboutInEdgeToOutEdgeMap, Map<AtlasEntity, Set<AtlasEntity>> nonRoundaboutInEdgeToOutEdgeMap, Node intersectingNode, Set<Relation> destinationSignRelations) {
        HashSet<AtlasEntity> entitiesToBeFlagged = new HashSet<AtlasEntity>();
        int instructionIndex = -1;
        if (!roundAboutInEdgeToOutEdgeMap.isEmpty()) {
            Set<AtlasEntity> allRoundaboutEdgesMissingTagsOrRelations = this.getAllRoundaboutEdgesMissingTagsOrRelations(roundAboutInEdgeToOutEdgeMap, destinationSignRelations);
            if (!allRoundaboutEdgesMissingTagsOrRelations.isEmpty()) {
                entitiesToBeFlagged.addAll(allRoundaboutEdgesMissingTagsOrRelations);
                instructionIndex = 4;
            }
        } else {
            Set<AtlasEntity> connectedEdgesNotFormDestinationRelation;
            Set<Relation> destinationSignRelationsMissingTag = this.getRelationsWithMissingDestinationTag(destinationSignRelations);
            if (!destinationSignRelationsMissingTag.isEmpty()) {
                this.markAsFlagged(String.valueOf(intersectingNode.getIdentifier()));
                instructionIndex = 1;
                entitiesToBeFlagged.addAll(destinationSignRelationsMissingTag);
            } else if (nonRoundaboutInEdgeToOutEdgeMap != null && !(connectedEdgesNotFormDestinationRelation = this.getConnectedEdgesNotFormDestinationRelation(nonRoundaboutInEdgeToOutEdgeMap, destinationSignRelations)).isEmpty()) {
                instructionIndex = 2;
                entitiesToBeFlagged.addAll(connectedEdgesNotFormDestinationRelation);
            }
        }
        return new FlaggedIntersection(instructionIndex, entitiesToBeFlagged);
    }

    private Optional<Set<Relation>> getParentDestinationSignRelations(AtlasEntity atlasEntity) {
        Set setOfDestinationSignRelations = atlasEntity.relations().stream().filter(relation -> RelationTypeTag.DESTINATION_SIGN.toString().equalsIgnoreCase(relation.tag("type"))).collect(Collectors.toSet());
        return setOfDestinationSignRelations.isEmpty() ? Optional.empty() : Optional.of(setOfDestinationSignRelations);
    }

    private Set<Relation> getRelationsWithMissingDestinationTag(Set<Relation> destinationSignRelations) {
        return destinationSignRelations.stream().filter(relation -> relation.tag("destination") == null).collect(Collectors.toSet());
    }

    private Set<AtlasEntity> getRoundaboutEdges(Edge startEdge) {
        return new SimpleEdgeWalker(startEdge, this.isRoundaboutEdge()).collectEdges().stream().map(AtlasEntity.class::cast).collect(Collectors.toSet());
    }

    private boolean isMatchingOutEdge(Edge inEdge, Edge outEdge) {
        return LevelTag.areOnSameLevel((Taggable)inEdge, (Taggable)outEdge) && LayerTag.areOnSameLayer((Taggable)inEdge, (Taggable)outEdge) && EDGE_DIRECTION_COMPARATOR.isSameDirection(inEdge, outEdge, true);
    }

    private boolean isMissingDestinationTag(Edge edge) {
        return OneWayTag.isExplicitlyTwoWay((Taggable)edge) && edge.tag("destination:forward") == null || !OneWayTag.isExplicitlyTwoWay((Taggable)edge) && edge.tag("destination") == null;
    }

    private Function<Edge, Stream<Edge>> isRoundaboutEdge() {
        return edge -> edge.connectedEdges().stream().filter(connected -> JunctionTag.isRoundabout((Taggable)connected) && HighwayTag.isCarNavigableHighway((Taggable)connected));
    }

    private boolean isValidIntersectingEdge(Edge edge) {
        return edge.isMasterEdge() && HighwayTag.highwayTag((Taggable)edge).isPresent() && this.highwayFilter.contains(edge.highwayTag().getTagValue());
    }

    private Map<String, Map<AtlasEntity, Set<AtlasEntity>>> populateInEdgeToOutEdgeMaps(List<Edge> inEdges, Set<Edge> outEdges) {
        HashMap nonRoundaboutInEdgeToOutEdgeMap = new HashMap();
        HashMap roundAboutInEdgeToOutEdgeMap = new HashMap();
        inEdges.forEach(inEdge -> {
            Set filteredOutEdges;
            Optional highwayTag = HighwayTag.highwayTag((Taggable)inEdge);
            if (highwayTag.isPresent() && this.connectedHighwayTypes.containsKey(((HighwayTag)highwayTag.get()).getTagValue()) && (filteredOutEdges = outEdges.stream().filter(outEdge -> this.isMatchingOutEdge((Edge)inEdge, (Edge)outEdge)).collect(Collectors.toSet())).size() >= 2) {
                String inEdgeHighwayType = ((HighwayTag)highwayTag.get()).getTagValue();
                List<String> validHighwayTypesOfOutEdge = this.connectedHighwayTypes.get(inEdgeHighwayType);
                Set filteredByHighways = filteredOutEdges.stream().filter(atlasEntity -> {
                    Optional atlasEntityHighway = HighwayTag.highwayTag((Taggable)atlasEntity);
                    return atlasEntityHighway.isPresent() && validHighwayTypesOfOutEdge.contains(((HighwayTag)atlasEntityHighway.get()).getTagValue());
                }).collect(Collectors.toSet());
                if (filteredByHighways.stream().anyMatch(JunctionTag::isRoundabout) || JunctionTag.isRoundabout((Taggable)inEdge)) {
                    roundAboutInEdgeToOutEdgeMap.put(inEdge, filteredByHighways);
                } else if (!filteredByHighways.isEmpty()) {
                    nonRoundaboutInEdgeToOutEdgeMap.put(inEdge, filteredByHighways);
                }
            }
        });
        HashMap<String, Map<AtlasEntity, Set<AtlasEntity>>> mapOfMatchingInAndOutEdges = new HashMap<String, Map<AtlasEntity, Set<AtlasEntity>>>();
        mapOfMatchingInAndOutEdges.put(NON_ROUNDABOUT_INTERSECTION_MAP, nonRoundaboutInEdgeToOutEdgeMap);
        mapOfMatchingInAndOutEdges.put(ROUNDABOUT_INTERSECTION_MAP, roundAboutInEdgeToOutEdgeMap);
        return mapOfMatchingInAndOutEdges;
    }

    private class FlaggedIntersection {
        private int instructionIndex;
        private Set<AtlasEntity> setOfFlaggedItems;

        FlaggedIntersection(int instructionIndex, Set<AtlasEntity> setOfFlaggedItems) {
            this.instructionIndex = instructionIndex;
            this.setOfFlaggedItems = setOfFlaggedItems;
        }

        private Set<AtlasEntity> getFlaggedItems() {
            return this.setOfFlaggedItems;
        }

        private Integer getInstructionIndex() {
            return this.instructionIndex;
        }
    }
}

