/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.utility;

import java.util.Set;
import org.locationtech.jts.geom.TopologyException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.clipping.Clip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntersectionUtilities {
    private static final Logger logger = LoggerFactory.getLogger(IntersectionUtilities.class);

    public static double findIntersectionPercentage(Polygon polygon, Polygon otherPolygon) {
        Clip clip = null;
        try {
            clip = polygon.clip(otherPolygon, Clip.ClipType.AND);
        }
        catch (TopologyException e) {
            logger.warn(String.format("Skipping intersection check. Error clipping [%s] and [%s].", polygon, otherPolygon), (Throwable)e);
        }
        if (clip == null) {
            return 0.0;
        }
        long intersectionArea = 0L;
        for (PolyLine polyline : clip.getClip()) {
            if (polyline == null || !(polyline instanceof Polygon)) continue;
            Polygon clippedPolygon = (Polygon)polyline;
            intersectionArea += clippedPolygon.surface().asDm7Squared();
        }
        if (intersectionArea == 0L) {
            return 0.0;
        }
        long baselineArea = Math.min(polygon.surface().asDm7Squared(), otherPolygon.surface().asDm7Squared());
        return (double)intersectionArea / (double)baselineArea;
    }

    public static boolean haveExplicitLocationsForIntersections(Polygon areaCrossed, LineItem crossingItem) {
        PolyLine crossingItemAsPolyLine = crossingItem.asPolyLine();
        Set intersections = areaCrossed.intersections(crossingItemAsPolyLine);
        for (Location intersection : intersections) {
            if (areaCrossed.contains(intersection) && crossingItemAsPolyLine.contains(intersection)) continue;
            return false;
        }
        return true;
    }

    private IntersectionUtilities() {
    }
}

