/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.openstreetmap.atlas.checks.maproulette.data.ChallengeDifficulty;
import org.openstreetmap.atlas.checks.maproulette.data.ChallengePriority;
import org.openstreetmap.atlas.checks.maproulette.serializer.ChallengeDifficultySerializer;

public class Challenge
implements Serializable {
    public static final String KEY_ACTIVE = "active";
    public static final String KEY_UPDATE_TASKS = "updateTasks";
    public static final String KEY_NAME = "name";
    public static final String KEY_DEFAULT_PRIORITY = "defaultPriority";
    public static final int KEY_DEFAULT_PRIORITY_VALUE = -1;
    public static final String KEY_HIGH_PRIORITY = "highPriorityRule";
    public static final String KEY_MEDIUM_PRIORITY = "mediumPriorityRule";
    public static final String KEY_LOW_PRIORITY = "lowPriorityRule";
    public static final String KEY_PRIORITY_RULES = "rules";
    public static final String KEY_RULE_ID = "id";
    public static final String VALUE_RULE_ID = "tag";
    public static final String KEY_RULE_FIELD = "field";
    public static final String VALUE_RULE_FIELD = "tag";
    public static final String KEY_RULE_TYPE = "type";
    public static final String VALUE_RULE_TYPE = "string";
    public static final String KEY_RULE_OPERATOR = "operator";
    public static final String VALUE_RULE_OPERATOR = "equal";
    public static final String KEY_RULE_VALUE = "value";
    public static final String KEY_TAGS = "tags";
    private static final long serialVersionUID = -8034692909431083341L;
    private static final Gson CHALLENGE_GSON = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(ChallengeDifficulty.class, (Object)new ChallengeDifficultySerializer()).create();
    private long identifier = -1L;
    private long parent = -1L;
    private final String blurb;
    private final String description;
    private final ChallengeDifficulty difficulty;
    private final String instruction;
    private String checkinComment;
    private String name;
    private final String tags;
    private final ChallengePriority defaultPriority;
    private final String highPriorityRule;
    private final String mediumPriorityRule;
    private final String lowPriorityRule;

    public Challenge(Challenge challenge) {
        this(challenge.name, challenge.description, challenge.blurb, challenge.instruction, challenge.difficulty, challenge.defaultPriority, challenge.highPriorityRule, challenge.mediumPriorityRule, challenge.lowPriorityRule, challenge.tags);
    }

    public Challenge(String name, String description, String blurb, String instruction, ChallengeDifficulty difficulty, String tags) {
        this(name, description, blurb, instruction, difficulty, ChallengePriority.LOW, null, null, null, tags);
    }

    public Challenge(String name, String description, String blurb, String instruction, String checkinComment, ChallengeDifficulty difficulty, String tags) {
        this(name, description, blurb, instruction, difficulty, ChallengePriority.LOW, null, null, null, tags);
        this.checkinComment = checkinComment;
    }

    public Challenge(String name, String description, String blurb, String instruction, ChallengeDifficulty difficulty, ChallengePriority defaultPriority, String highPriorityRule, String mediumPriorityRule, String lowPriorityRule, String tags) {
        this.name = name;
        this.description = description;
        this.blurb = blurb;
        this.instruction = instruction;
        this.difficulty = difficulty;
        this.defaultPriority = defaultPriority;
        this.highPriorityRule = highPriorityRule;
        this.mediumPriorityRule = mediumPriorityRule;
        this.lowPriorityRule = lowPriorityRule;
        this.tags = tags;
        this.checkinComment = "#maproulette";
    }

    public String getBlurb() {
        return this.blurb;
    }

    public String getCheckinComment() {
        return this.checkinComment;
    }

    public ChallengePriority getDefaultPriority() {
        return this.defaultPriority;
    }

    public String getDescription() {
        return this.description;
    }

    public ChallengeDifficulty getDifficulty() {
        return this.difficulty;
    }

    public String getHighPriorityRule() {
        return this.highPriorityRule;
    }

    public long getId() {
        return this.identifier;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getLowPriorityRule() {
        return this.lowPriorityRule;
    }

    public String getMediumPriorityRule() {
        return this.mediumPriorityRule;
    }

    public String getName() {
        return this.name;
    }

    public long getParentIdentifier() {
        return this.parent;
    }

    public String getTags() {
        return this.tags;
    }

    public void setCheckinComment(String checkinComment) {
        this.checkinComment = checkinComment;
    }

    public void setId(long identifier) {
        this.identifier = identifier;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentIdentifier(long identifier) {
        this.parent = identifier;
    }

    public JsonObject toJson(String challengeName) {
        JsonObject challengeJson = CHALLENGE_GSON.toJsonTree((Object)this).getAsJsonObject();
        challengeJson.add(KEY_ACTIVE, (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        challengeJson.add(KEY_UPDATE_TASKS, (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        if (this.name.isEmpty()) {
            challengeJson.add(KEY_NAME, (JsonElement)new JsonPrimitive(challengeName));
        }
        if (this.defaultPriority != null) {
            challengeJson.add(KEY_DEFAULT_PRIORITY, (JsonElement)new JsonPrimitive((Number)this.defaultPriority.intValue()));
            challengeJson.addProperty(KEY_HIGH_PRIORITY, this.getPriorityRuleString(this.highPriorityRule));
            challengeJson.add(KEY_MEDIUM_PRIORITY, (JsonElement)new JsonPrimitive(this.getPriorityRuleString(this.mediumPriorityRule)));
            challengeJson.add(KEY_LOW_PRIORITY, (JsonElement)new JsonPrimitive(this.getPriorityRuleString(this.lowPriorityRule)));
        } else {
            challengeJson.add(KEY_DEFAULT_PRIORITY, (JsonElement)new JsonPrimitive((Number)ChallengePriority.MEDIUM.intValue()));
        }
        return challengeJson;
    }

    private String getPriorityRuleString(String priorityString) {
        if (StringUtils.isEmpty((String)priorityString)) {
            return "";
        }
        JsonArray fixedRules = new JsonArray();
        JsonObject priority = (JsonObject)CHALLENGE_GSON.fromJson(priorityString, JsonObject.class);
        JsonArray rules = priority.getAsJsonArray(KEY_PRIORITY_RULES);
        rules.forEach(rule -> {
            if (rule.isJsonObject()) {
                fixedRules.add(rule);
            } else {
                String[] ruleElements = rule.getAsString().split("=");
                if (ruleElements.length == 2) {
                    JsonObject ruleObject = new JsonObject();
                    ruleObject.add(KEY_RULE_ID, (JsonElement)new JsonPrimitive("tag"));
                    ruleObject.add(KEY_RULE_FIELD, (JsonElement)new JsonPrimitive("tag"));
                    ruleObject.add(KEY_RULE_TYPE, (JsonElement)new JsonPrimitive(VALUE_RULE_TYPE));
                    ruleObject.add(KEY_RULE_OPERATOR, (JsonElement)new JsonPrimitive(VALUE_RULE_OPERATOR));
                    ruleObject.add(KEY_RULE_VALUE, (JsonElement)new JsonPrimitive(String.format("%s.%s", ruleElements[0], ruleElements[1])));
                    fixedRules.add((JsonElement)ruleObject);
                }
            }
        });
        priority.add(KEY_PRIORITY_RULES, (JsonElement)fixedRules);
        return priority.toString();
    }
}

