/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.flag;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.checks.flag.FlaggedObject;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteArea;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLine;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.geojson.GeoJsonUtils;

public class FlaggedPolyline
extends FlaggedObject {
    private static final long serialVersionUID = -1184306312148054279L;
    private final AtlasItem atlasItem;
    private final String country;
    private final PolyLine polyLine;
    private final Map<String, String> properties;

    public FlaggedPolyline(AtlasItem atlasItem) {
        this.atlasItem = atlasItem;
        this.polyLine = atlasItem instanceof Area ? new PolyLine(((Area)atlasItem).asPolygon().closedLoop()) : new PolyLine(atlasItem.getRawGeometry());
        this.properties = this.initProperties((AtlasObject)atlasItem);
        this.country = this.initCountry((AtlasObject)atlasItem);
    }

    @Override
    public JsonObject asGeoJsonFeature(String flagIdentifier) {
        JsonObject geoJsonGeometry = this.atlasItem.asGeoJsonGeometry();
        JsonObject jsonProperties = this.atlasItem.getGeoJsonProperties();
        jsonProperties.addProperty("flag:id", flagIdentifier);
        jsonProperties.addProperty("flag:type", FlaggedPolyline.class.getSimpleName());
        return GeoJsonUtils.feature((JsonObject)geoJsonGeometry, (JsonObject)jsonProperties);
    }

    public Rectangle bounds() {
        return this.atlasItem.bounds();
    }

    @Override
    public FlaggedObject getAsCompleteFlaggedObject() {
        if (this.atlasItem instanceof Area) {
            return new FlaggedPolyline((AtlasItem)CompleteArea.from((Area)((Area)this.atlasItem)));
        }
        if (this.atlasItem instanceof Edge) {
            return new FlaggedPolyline((AtlasItem)CompleteEdge.from((Edge)((Edge)this.atlasItem)));
        }
        if (this.atlasItem instanceof Line) {
            return new FlaggedPolyline((AtlasItem)CompleteLine.from((Line)((Line)this.atlasItem)));
        }
        throw new CoreException("FlaggedPolyline has improper Atlas Item {}", new Object[]{this.atlasItem});
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public Iterable<Location> getGeometry() {
        return this.polyLine;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    protected Optional<AtlasObject> getObject() {
        return Optional.ofNullable(this.atlasItem);
    }

    private String initCountry(AtlasObject object) {
        Map tags = object.getTags();
        if (tags.containsKey("iso_country_code")) {
            return (String)tags.get("iso_country_code");
        }
        return "N/A";
    }

    private Map<String, String> initProperties(AtlasObject object) {
        Map tags = object.getTags();
        tags.put("identifier", "" + object.getIdentifier());
        tags.put("osmIdentifier", "" + object.getOsmIdentifier());
        if (object instanceof Area) {
            tags.put("itemType", "Area");
        } else if (object instanceof Line) {
            tags.put("itemType", "Line");
        } else if (object instanceof Edge) {
            tags.put("itemType", "Edge");
        } else if (object instanceof Node) {
            tags.put("itemType", "Node");
        } else if (object instanceof Point) {
            tags.put("itemType", "Point");
        }
        return tags;
    }
}

