/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.flag;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.checks.flag.FlaggedObject;
import org.openstreetmap.atlas.checks.flag.FlaggedPoint;
import org.openstreetmap.atlas.checks.flag.FlaggedPolyline;
import org.openstreetmap.atlas.checks.flag.FlaggedRelation;
import org.openstreetmap.atlas.checks.maproulette.data.Task;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.geography.geojson.GeoJsonType;
import org.openstreetmap.atlas.geography.geojson.GeoJsonUtils;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckFlag
implements Iterable<Location>,
Located,
Serializable {
    private static final Distance TEN_METERS = Distance.meters((double)10.0);
    private static final String NULL_IDENTIFIERS = "nullnull";
    private static final Logger logger = LoggerFactory.getLogger(CheckFlag.class);
    private static final long serialVersionUID = -1287808902452203852L;
    private String challengeName = null;
    private Set<FlaggedObject> flaggedObjects = new LinkedHashSet<FlaggedObject>();
    private final String identifier;
    private final List<String> instructions = new ArrayList<String>();

    public CheckFlag(String identifier) {
        this.identifier = identifier;
    }

    public CheckFlag(String identifier, Set<? extends AtlasObject> objects, List<String> instructions) {
        this(identifier, objects, instructions, new ArrayList<Location>());
    }

    public CheckFlag(String identifier, Set<? extends AtlasObject> objects, List<String> instructions, List<Location> points) {
        this.addObjects(objects);
        this.addPoints(points);
        this.addInstructions(instructions);
        this.identifier = identifier;
    }

    public void addInstruction(String instruction) {
        if (StringUtils.isNotEmpty((CharSequence)instruction)) {
            this.instructions.add(instruction);
        }
    }

    public void addInstructions(Iterable<String> instructions) {
        instructions.forEach(this::addInstruction);
    }

    public void addObject(AtlasObject object) {
        if (object instanceof AtlasItem) {
            if (object instanceof LocationItem) {
                this.flaggedObjects.add(new FlaggedPoint((LocationItem)object));
            } else {
                this.flaggedObjects.add(new FlaggedPolyline((AtlasItem)object));
            }
        } else if (object instanceof Relation) {
            this.flaggedObjects.add(new FlaggedRelation((Relation)object));
        }
    }

    public void addObject(AtlasObject object, Location point, String instruction) {
        this.addObject(object);
        this.addPoint(point);
        this.addInstruction(instruction);
    }

    public void addObject(AtlasObject object, String instruction) {
        this.addObject(object);
        this.addInstruction(instruction);
    }

    public void addObjects(Iterable<? extends AtlasObject> objects) {
        objects.forEach(this::addObject);
    }

    public void addPoint(Location point) {
        this.flaggedObjects.add(new FlaggedPoint(point));
    }

    public void addPoints(Iterable<Location> points) {
        Iterables.stream(points).map(FlaggedPoint::new).forEach(this.flaggedObjects::add);
    }

    public JsonObject asGeoJsonFeature() {
        JsonObject geometry = this.boundsGeoJsonGeometry();
        JsonObject properties = new JsonObject();
        properties.addProperty("flag:type", CheckFlag.class.getSimpleName());
        properties.addProperty("flag:id", this.getIdentifier());
        properties.addProperty("flag:instructions", this.getInstructions());
        if (this.challengeName != null) {
            properties.addProperty("flag:challenge", this.challengeName);
        }
        return GeoJsonUtils.feature((JsonObject)geometry, (JsonObject)properties);
    }

    public Rectangle bounds() {
        return Rectangle.forLocated((Iterable)new MultiIterable(this.getShapes()));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CheckFlag)) {
            return false;
        }
        CheckFlag otherFlag = (CheckFlag)other;
        return Objects.equals(this.identifier, otherFlag.identifier) && Objects.equals(this.challengeName, otherFlag.challengeName) && Objects.equals(this.instructions, otherFlag.instructions) && Objects.equals(this.flaggedObjects, otherFlag.flaggedObjects);
    }

    public Optional<String> getChallengeName() {
        return Optional.ofNullable(this.challengeName);
    }

    public String getCountryISO() {
        for (FlaggedObject object : this.flaggedObjects) {
            if (!object.hasCountry()) continue;
            return object.getCountry();
        }
        return "NA";
    }

    public Set<FlaggedObject> getFlaggedObjects() {
        return this.flaggedObjects;
    }

    public Set<FlaggedObject> getFlaggedRelations() {
        return this.flaggedObjects.stream().filter(FlaggedRelation.class::isInstance).collect(Collectors.toSet());
    }

    public List<GeoJsonBuilder.GeometryWithProperties> getGeometryWithProperties() {
        return this.flaggedObjects.stream().filter(flaggedObject -> flaggedObject instanceof FlaggedPoint || flaggedObject instanceof FlaggedPolyline).map(flaggedObject -> new GeoJsonBuilder.GeometryWithProperties(flaggedObject.getGeometry(), new HashMap<String, String>(flaggedObject.getProperties()))).collect(Collectors.toList());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getInstructions() {
        StringBuilder builder = new StringBuilder();
        int instructionNumber = 1;
        for (String instruction : this.instructions) {
            if (!StringUtils.isNotEmpty((CharSequence)instruction)) continue;
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(instructionNumber++ + ". " + instruction);
        }
        return builder.toString();
    }

    public Task getMapRouletteTask() {
        Set<FlaggedObject> flaggedRelations;
        Task task = new Task();
        task.setInstruction(this.getInstructions());
        task.setProjectName(this.getCountryISO());
        task.setChallengeName(this.getChallengeName().orElse(this.getClass().getSimpleName()));
        task.setTaskIdentifier(this.identifier);
        Set<Location> points = this.getPoints();
        if (!points.isEmpty()) {
            task.setPoints(points);
        } else {
            Set<PolyLine> polyLines = this.getPolyLines();
            if (!polyLines.isEmpty()) {
                task.setPoint((Location)polyLines.iterator().next().iterator().next());
            }
        }
        JsonArray features = new JsonArray();
        if (!this.getGeometryWithProperties().isEmpty()) {
            this.getGeometryWithProperties().forEach(shape -> features.add((JsonElement)new GeoJsonBuilder().create(shape)));
        }
        if (!(flaggedRelations = this.getFlaggedRelations()).isEmpty()) {
            this.getFlaggedRelations().stream().map(flaggedRelation -> flaggedRelation.asGeoJsonFeature(this.identifier)).forEach(arg_0 -> ((JsonArray)features).add(arg_0));
        }
        task.setGeoJson(Optional.of(features));
        return task;
    }

    public Set<Location> getPoints() {
        return this.flaggedObjects.stream().map(FlaggedObject::getGeometry).filter(geometry -> geometry instanceof Location).map(geometry -> (Location)geometry).collect(Collectors.toSet());
    }

    public Set<PolyLine> getPolyLines() {
        return this.flaggedObjects.stream().map(FlaggedObject::getGeometry).filter(geometry -> geometry instanceof PolyLine).map(geometry -> (PolyLine)geometry).collect(Collectors.toSet());
    }

    public Iterable<Iterable<Location>> getShapes() {
        return Iterables.asIterable((Iterable)this.getPolyLines().stream().map(polyLine -> polyLine).collect(Collectors.toList()));
    }

    public Set<String> getUniqueIdentifiers() {
        Set<String> flaggedObjectIdentifiers = this.flaggedObjects.stream().map(object -> object.getProperties().get("itemType") + object.getProperties().get("identifier")).filter(string -> !string.equals(NULL_IDENTIFIERS)).collect(Collectors.toSet());
        return flaggedObjectIdentifiers.isEmpty() ? Collections.singleton(this.identifier) : flaggedObjectIdentifiers;
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.challengeName, this.instructions, this.flaggedObjects);
    }

    @Override
    public Iterator<Location> iterator() {
        return new MultiIterable(this.getShapes()).iterator();
    }

    public CheckFlag makeComplete() {
        LinkedHashSet<FlaggedObject> completeFlaggedObjects = new LinkedHashSet<FlaggedObject>();
        this.flaggedObjects.forEach(flaggedObject -> completeFlaggedObjects.add(flaggedObject.getAsCompleteFlaggedObject()));
        this.flaggedObjects = completeFlaggedObjects;
        return this;
    }

    public void save(WritableResource writableResource) {
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(writableResource.write(), StandardCharsets.UTF_8));){
            out.write(this.toString());
        }
        catch (Exception e) {
            throw new CoreException("Could not save Check Flag to {}", (Throwable)e, new Object[]{writableResource});
        }
    }

    public void setChallengeName(String challengeName) {
        this.challengeName = challengeName;
    }

    public String toString() {
        return String.format("[CheckFlag: %s, %s]", this.identifier, this.getInstructions());
    }

    private JsonObject boundsGeoJsonGeometry() {
        Rectangle bounds;
        Iterator<FlaggedObject> iterator = this.flaggedObjects.iterator();
        if (iterator.hasNext()) {
            bounds = iterator.next().bounds();
        } else {
            return GeoJsonUtils.geometry((GeoJsonType)GeoJsonType.POINT, (JsonArray)GeoJsonUtils.coordinate((double)0.0, (double)0.0));
        }
        while (iterator.hasNext()) {
            Rectangle nextBounds = iterator.next().bounds();
            bounds = bounds.combine(nextBounds);
        }
        if (bounds.width().onEarth().isLessThan(TEN_METERS)) {
            bounds = bounds.expandHorizontally(TEN_METERS);
        }
        if (bounds.height().onEarth().isLessThan(TEN_METERS)) {
            bounds = bounds.expandVertically(TEN_METERS);
        }
        return GeoJsonUtils.boundsToPolygonGeometry((Rectangle)bounds);
    }
}

