/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.distributed;

import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public final class AtlasFilePathResolver
implements Serializable {
    private static final long serialVersionUID = -6293318204002353071L;
    private static final String DEFAULT_PATH_TEMPLATE = "%s/%s";
    private final Map<String, String> pathTemplate;

    public AtlasFilePathResolver(Configuration configuration) {
        this.pathTemplate = Collections.unmodifiableMap((Map)configuration.get(AtlasFilePathResolver.class.getSimpleName() + ".schema.path.templates", Collections.emptyMap()).value());
    }

    public String resolvePath(String basePath, String country) {
        URI uri = URI.create(basePath);
        String template = Optional.ofNullable(uri.getScheme()).map(this.pathTemplate::get).orElse(this.pathTemplate.getOrDefault("default", DEFAULT_PATH_TEMPLATE));
        return String.format(template, basePath, country);
    }
}

