/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.database;

import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DatabaseConnection
implements AutoCloseable {
    private URI connectionURI;
    private Map<String, String> queryParameters = new HashMap<String, String>();
    private static final String DEFAULT_DATABASE_SCHEMA = "public";

    public DatabaseConnection(String connectionUrl) {
        this.connectionURI = this.createConnectionURI(connectionUrl);
        this.queryParameters = this.uriQueryToMap(this.connectionURI);
    }

    @Override
    public void close() throws SQLException {
        this.getConnection().close();
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(String.format("jdbc:%s", this.connectionURI.toString()));
    }

    public URI getConnectionURI() {
        return this.connectionURI;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public String getSchema() {
        return this.uriQueryToMap(this.connectionURI).getOrDefault("currentSchema", DEFAULT_DATABASE_SCHEMA);
    }

    private URI createConnectionURI(String connectionString) {
        return URI.create(String.format("postgresql://%s", connectionString));
    }

    private Map<String, String> uriQueryToMap(URI connectionURI) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (connectionURI.getQuery() != null) {
            Arrays.stream(connectionURI.getQuery().split("&")).map(record -> record.split("=")).forEach(value -> queryMap.put(value[0], value[1]));
        }
        return queryMap;
    }
}

