/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

public class JSONParser {
    private static final String NUMBER_REGEX = "-?(?:0|[1-9]\\d*)(?:\\.\\d+)?(?:[eE][+-]?\\d+)?";

    private JSONParser() {
    }

    public static Object parseJSON(final String s2) throws JSONException {
        if (s2.trim().startsWith("{")) {
            return new JSONObject(s2);
        }
        if (s2.trim().startsWith("[")) {
            return new JSONArray(s2);
        }
        if (s2.trim().startsWith("\"") || s2.trim().matches(NUMBER_REGEX)) {
            return new JSONString(){

                @Override
                public String toJSONString() {
                    return s2;
                }
            };
        }
        throw new JSONException("Unparsable JSON string: " + s2);
    }
}

