/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.postgresql.shaded.com.ongres.scram.common.ScramMechanism;
import org.postgresql.shaded.com.ongres.scram.common.util.Preconditions;

public enum ScramMechanisms implements ScramMechanism
{
    SCRAM_SHA_1("SHA-1", "SHA-1", 160, "HmacSHA1", false, 1),
    SCRAM_SHA_1_PLUS("SHA-1", "SHA-1", 160, "HmacSHA1", true, 1),
    SCRAM_SHA_256("SHA-256", "SHA-256", 256, "HmacSHA256", false, 10),
    SCRAM_SHA_256_PLUS("SHA-256", "SHA-256", 256, "HmacSHA256", true, 10);

    private static final String SCRAM_MECHANISM_NAME_PREFIX = "SCRAM-";
    private static final String CHANNEL_BINDING_SUFFIX = "-PLUS";
    private static final String PBKDF2_PREFIX_ALGORITHM_NAME = "PBKDF2With";
    private static final Map<String, ScramMechanisms> BY_NAME_MAPPING;
    private final String mechanismName;
    private final String hashAlgorithmName;
    private final int keyLength;
    private final String hmacAlgorithmName;
    private final boolean channelBinding;
    private final int priority;

    private ScramMechanisms(String name, String hashAlgorithmName, int keyLength, String hmacAlgorithmName, boolean channelBinding, int priority) {
        this.mechanismName = SCRAM_MECHANISM_NAME_PREFIX + Preconditions.checkNotNull(name, "name") + (channelBinding ? CHANNEL_BINDING_SUFFIX : "");
        this.hashAlgorithmName = Preconditions.checkNotNull(hashAlgorithmName, "hashAlgorithmName");
        this.keyLength = Preconditions.gt0(keyLength, "keyLength");
        this.hmacAlgorithmName = Preconditions.checkNotNull(hmacAlgorithmName, "hmacAlgorithmName");
        this.channelBinding = channelBinding;
        this.priority = Preconditions.gt0(priority, "priority");
    }

    protected String getHashAlgorithmName() {
        return this.hashAlgorithmName;
    }

    protected String getHmacAlgorithmName() {
        return this.hmacAlgorithmName;
    }

    @Override
    public String getName() {
        return this.mechanismName;
    }

    @Override
    public boolean supportsChannelBinding() {
        return this.channelBinding;
    }

    @Override
    public MessageDigest getMessageDigestInstance() {
        try {
            return MessageDigest.getInstance(this.hashAlgorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Algorithm " + this.hashAlgorithmName + " not present in current JVM");
        }
    }

    @Override
    public Mac getMacInstance() {
        try {
            return Mac.getInstance(this.hmacAlgorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MAC Algorithm " + this.hmacAlgorithmName + " not present in current JVM");
        }
    }

    @Override
    public SecretKeySpec secretKeySpec(byte[] key) {
        return new SecretKeySpec(key, this.hmacAlgorithmName);
    }

    @Override
    public SecretKeyFactory secretKeyFactory() {
        try {
            return SecretKeyFactory.getInstance(PBKDF2_PREFIX_ALGORITHM_NAME + this.hmacAlgorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unsupported PBKDF2 for " + this.mechanismName);
        }
    }

    @Override
    public int algorithmKeyLength() {
        return this.keyLength;
    }

    public static Optional<ScramMechanisms> byName(String name) {
        Preconditions.checkNotNull(name, "name");
        return Optional.ofNullable(BY_NAME_MAPPING.get(name));
    }

    public static Optional<ScramMechanism> selectMatchingMechanism(boolean channelBinding, String ... peerMechanisms) {
        return Arrays.stream(peerMechanisms).map(s2 -> BY_NAME_MAPPING.get(s2)).filter(m3 -> m3 != null).flatMap(m3 -> Arrays.stream(ScramMechanisms.values()).filter(v -> channelBinding == v.channelBinding && v.mechanismName.equals(m3.mechanismName))).max(Comparator.comparing(c -> c.priority)).map(m3 -> m3);
    }

    static {
        BY_NAME_MAPPING = Arrays.stream(ScramMechanisms.values()).collect(Collectors.toMap(v -> v.getName(), v -> v));
    }
}

