/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc4;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Field;
import org.postgresql.core.Query;
import org.postgresql.core.ResultCursor;
import org.postgresql.jdbc4.AbstractJdbc4ResultSet;
import org.postgresql.jdbc4.Jdbc4Array;
import org.postgresql.jdbc4.Jdbc4Blob;
import org.postgresql.jdbc4.Jdbc4Clob;
import org.postgresql.jdbc4.Jdbc4ResultSetMetaData;

public class Jdbc4ResultSet
extends AbstractJdbc4ResultSet
implements ResultSet {
    Jdbc4ResultSet(Query originalQuery, BaseStatement statement, Field[] fields, Vector tuples, ResultCursor cursor, int maxRows, int maxFieldSize, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(originalQuery, statement, fields, tuples, cursor, maxRows, maxFieldSize, rsType, rsConcurrency, rsHoldability);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new Jdbc4ResultSetMetaData(this.connection, this.fields);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.checkResultSet(i);
        if (this.wasNullFlag) {
            return null;
        }
        return new Jdbc4Clob(this.connection, this.getLong(i));
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.checkResultSet(i);
        if (this.wasNullFlag) {
            return null;
        }
        return new Jdbc4Blob(this.connection, this.getLong(i));
    }

    @Override
    public Array createArray(int i) throws SQLException {
        this.checkResultSet(i);
        int oid = this.fields[i - 1].getOID();
        String value = this.getFixedString(i);
        return new Jdbc4Array(this.connection, oid, value);
    }

    @Override
    public Object getObject(String s2, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(s2, map);
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(i, map);
    }
}

