/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.common;

import java.util.Calendar;
import org.openstreetmap.osmosis.core.domain.common.SimpleTimestampContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampFormat;
import org.openstreetmap.osmosis.core.domain.common.UnparsedTimestampContainer;
import org.openstreetmap.osmosis.xml.common.DummyElementProcessor;
import org.openstreetmap.osmosis.xml.common.ElementProcessor;
import org.openstreetmap.osmosis.xml.common.XmlTimestampFormat;

public abstract class BaseElementProcessor
implements ElementProcessor {
    private BaseElementProcessor parentProcessor;
    private ElementProcessor dummyChildProcessor;
    private TimestampFormat timestampFormat;
    private TimestampContainer dummyTimestampContainer;
    private boolean enableDateParsing;

    protected BaseElementProcessor(BaseElementProcessor parentProcessor, boolean enableDateParsing) {
        this.parentProcessor = parentProcessor;
        this.enableDateParsing = enableDateParsing;
        if (enableDateParsing) {
            this.timestampFormat = new XmlTimestampFormat();
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.set(14, 0);
            this.dummyTimestampContainer = new SimpleTimestampContainer(calendar.getTime());
        }
    }

    @Override
    public ElementProcessor getChild(String uri, String localName, String qName) {
        if (this.dummyChildProcessor == null) {
            this.dummyChildProcessor = new DummyElementProcessor(this);
        }
        return this.dummyChildProcessor;
    }

    @Override
    public ElementProcessor getParent() {
        return this.parentProcessor;
    }

    protected TimestampContainer createTimestampContainer(String data) {
        if (this.enableDateParsing) {
            return new UnparsedTimestampContainer(this.timestampFormat, data);
        }
        return this.dummyTimestampContainer;
    }
}

