/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.hstore;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.postgresql.util.PGobject;

public class PGHStore
extends PGobject
implements Serializable,
Cloneable,
Map<String, String> {
    private static final long serialVersionUID = 1L;
    private Map<String, String> _map;

    public PGHStore() {
        this.setType("hstore");
        this._map = new HashMap<String, String>();
    }

    public PGHStore(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public PGHStore(Map<String, String> map) {
        this();
        this.setValue(map);
    }

    public void setValue(Map<String, String> map) {
        this._map = map;
    }

    @Override
    public void setValue(String value) throws SQLException {
        Parser p = new Parser();
        this._map = p.parse(value);
    }

    @Override
    public String getValue() {
        StringBuffer buf = new StringBuffer();
        Iterator<String> i = this._map.keySet().iterator();
        boolean first = true;
        while (i.hasNext()) {
            String key = i.next();
            String value = this._map.get(key);
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            PGHStore.writeValue(buf, key);
            buf.append("=>");
            PGHStore.writeValue(buf, value);
        }
        return buf.toString();
    }

    private static void writeValue(StringBuffer buf, Object o) {
        if (o == null) {
            buf.append("NULL");
            return;
        }
        String s2 = o.toString();
        buf.append('\"');
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '\"' || c == '\\') {
                buf.append('\\');
            }
            buf.append(c);
        }
        buf.append('\"');
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PGHStore)) {
            return false;
        }
        return ((Object)this._map).equals(((PGHStore)obj)._map);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this._map.entrySet();
    }

    @Override
    public String get(Object key) {
        return this._map.get(key);
    }

    @Override
    public int hashCode() {
        return ((Object)this._map).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this._map.keySet();
    }

    @Override
    public String put(String key, String value) {
        return this._map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m3) {
        this._map.putAll(m3);
    }

    @Override
    public String remove(Object key) {
        return this._map.remove(key);
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public Collection<String> values() {
        return this._map.values();
    }

    private static class Parser {
        private String value;
        private int ptr;
        private StringBuffer cur;
        private boolean escaped;
        private List<String> keys;
        private List<String> values;
        private static final int GV_WAITVAL = 0;
        private static final int GV_INVAL = 1;
        private static final int GV_INESCVAL = 2;
        private static final int GV_WAITESCIN = 3;
        private static final int GV_WAITESCESCIN = 4;
        private static final int WKEY = 0;
        private static final int WVAL = 1;
        private static final int WEQ = 2;
        private static final int WGT = 3;
        private static final int WDEL = 4;

        private Map<String, String> parse(String value) throws SQLException {
            this.value = value;
            this.ptr = 0;
            this.keys = new ArrayList<String>();
            this.values = new ArrayList<String>();
            this.parseHStore();
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < this.keys.size(); ++i) {
                map.put(this.keys.get(i), this.values.get(i));
            }
            return map;
        }

        private boolean getValue(boolean ignoreEqual) throws SQLException {
            int state = 0;
            this.cur = new StringBuffer();
            this.escaped = false;
            while (true) {
                boolean atEnd = this.value.length() == this.ptr;
                char c = '\u0000';
                if (!atEnd) {
                    c = this.value.charAt(this.ptr);
                }
                if (state == 0) {
                    if (c == '\"') {
                        this.escaped = true;
                        state = 2;
                    } else {
                        if (c == '\u0000') {
                            return false;
                        }
                        if (c == '=' && !ignoreEqual) {
                            throw new SQLException("KJJ");
                        }
                        if (c == '\\') {
                            state = 3;
                        } else if (!Character.isWhitespace(c)) {
                            this.cur.append(c);
                            state = 1;
                        }
                    }
                } else if (state == 1) {
                    if (c == '\\') {
                        state = 3;
                    } else {
                        if (c == '=' && !ignoreEqual) {
                            --this.ptr;
                            return true;
                        }
                        if (c == ',' && ignoreEqual) {
                            --this.ptr;
                            return true;
                        }
                        if (Character.isWhitespace(c)) {
                            return true;
                        }
                        if (c == '\u0000') {
                            --this.ptr;
                            return true;
                        }
                        this.cur.append(c);
                    }
                } else if (state == 2) {
                    if (c == '\\') {
                        state = 4;
                    } else {
                        if (c == '\"') {
                            return true;
                        }
                        if (c == '\u0000') {
                            throw new SQLException("KJJ, unexpected end of string");
                        }
                        this.cur.append(c);
                    }
                } else if (state == 3) {
                    if (c == '\u0000') {
                        throw new SQLException("KJJ, unexpected end of string");
                    }
                    this.cur.append(c);
                    state = 1;
                } else if (state == 4) {
                    if (c == '\u0000') {
                        throw new SQLException("KJJ, unexpected end of string");
                    }
                    this.cur.append(c);
                    state = 2;
                } else {
                    throw new SQLException("KJJ");
                }
                ++this.ptr;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void parseHStore() throws SQLException {
            int state = 0;
            this.escaped = false;
            while (true) {
                block24: {
                    char c = '\u0000';
                    if (this.ptr < this.value.length()) {
                        c = this.value.charAt(this.ptr);
                    }
                    if (state == 0) {
                        if (!this.getValue(false)) {
                            return;
                        }
                        this.keys.add(this.cur.toString());
                        this.cur = null;
                        state = 2;
                    } else if (state == 2) {
                        if (c == '=') {
                            state = 3;
                        } else {
                            if (state == 0) {
                                throw new SQLException("KJJ, unexpected end of string");
                            }
                            if (!Character.isWhitespace(c)) {
                                throw new SQLException("KJJ, syntax err");
                            }
                        }
                    } else {
                        if (state == 3) {
                            if (c == '>') {
                                state = 1;
                                break block24;
                            } else {
                                if (c == '\u0000') {
                                    throw new SQLException("KJJ, unexpected end of string");
                                }
                                throw new SQLException("KJJ, syntax err [" + c + "] at " + this.ptr);
                            }
                        }
                        if (state == 1) {
                            if (!this.getValue(true)) {
                                throw new SQLException("KJJ, unexpected end of string");
                            }
                            String val = this.cur.toString();
                            this.cur = null;
                            if (!this.escaped && "null".equalsIgnoreCase(val)) {
                                val = null;
                            }
                            this.values.add(val);
                            state = 4;
                        } else {
                            if (state != 4) {
                                throw new SQLException("KJJ unknown state");
                            }
                            if (c == ',') {
                                state = 0;
                            } else {
                                if (c == '\u0000') {
                                    return;
                                }
                                if (!Character.isWhitespace(c)) {
                                    throw new SQLException("KJJ, syntax err");
                                }
                            }
                        }
                    }
                }
                ++this.ptr;
            }
        }
    }
}

