/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.lifecycle.Releasable;
import org.openstreetmap.osmosis.core.store.BufferedRandomAccessFileInputStream;
import org.openstreetmap.osmosis.core.store.ObjectDataInputIterator;
import org.openstreetmap.osmosis.core.store.ObjectReader;

public class RandomAccessObjectStoreReader<T>
implements Releasable {
    private static final Logger LOG = Logger.getLogger(RandomAccessObjectStoreReader.class.getName());
    private BufferedRandomAccessFileInputStream randomFile;
    private ObjectReader objectReader;

    public RandomAccessObjectStoreReader(BufferedRandomAccessFileInputStream randomFile, ObjectReader objectReader) {
        this.randomFile = randomFile;
        this.objectReader = objectReader;
    }

    private void seek(long offset) {
        try {
            this.randomFile.seek(offset);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to seek to position " + offset + " in the storage file.", e);
        }
    }

    public T get(long offset) {
        this.seek(offset);
        return (T)this.objectReader.readObject();
    }

    public long length() {
        try {
            return this.randomFile.length();
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to obtain the length of the storage file.", e);
        }
    }

    public long position() {
        try {
            return this.randomFile.position();
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to obtain the current position in the storage file.", e);
        }
    }

    public Iterator<T> iterate(long offset) {
        this.seek(offset);
        return new ObjectDataInputIterator(this.objectReader);
    }

    public Iterator<T> iterate() {
        return this.iterate(0L);
    }

    @Override
    public void release() {
        if (this.randomFile != null) {
            try {
                this.randomFile.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to close random access file.", e);
            }
            this.randomFile = null;
        }
    }
}

