/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.core.store.IndexElement;

public class IndexRangeIterator<K, T extends IndexElement<K>>
implements Iterator<T> {
    private Iterator<T> source;
    private K beginKey;
    private K endKey;
    private Comparator<K> ordering;
    private boolean nextRecordAvailable;
    private T nextRecord;

    public IndexRangeIterator(Iterator<T> source, K beginKey, K endKey, Comparator<K> ordering) {
        this.source = source;
        this.beginKey = beginKey;
        this.endKey = endKey;
        this.ordering = ordering;
        this.nextRecordAvailable = false;
    }

    @Override
    public boolean hasNext() {
        while (!this.nextRecordAvailable && this.source.hasNext()) {
            this.nextRecord = (IndexElement)this.source.next();
            Object key = this.nextRecord.getKey();
            if (this.ordering.compare(key, this.beginKey) < 0) continue;
            if (this.ordering.compare(this.nextRecord.getKey(), this.endKey) > 0) break;
            this.nextRecordAvailable = true;
        }
        return this.nextRecordAvailable;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextRecordAvailable = false;
        return this.nextRecord;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

