/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.vectortiles;

import com.google.gson.JsonObject;
import java.util.function.BiConsumer;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.vectortiles.MinimumZoom;
import org.openstreetmap.atlas.utilities.vectortiles.TippecanoeGeoJsonExtension;

public final class TippecanoeSettings {
    public static final DefaultArtifactVersion MIN_VERSION = new DefaultArtifactVersion("1.32.1");
    public static final String[] ARGS = new String[]{"-Z6", "-z14", "--generate-ids", "--read-parallel", "--no-tile-size-limit", "--no-feature-limit"};
    public static final BiConsumer<AtlasEntity, JsonObject> JSON_MUTATOR = (atlasEntity, feature) -> {
        TippecanoeGeoJsonExtension tippecanoe = new TippecanoeGeoJsonExtension().addTo((JsonObject)feature);
        ItemType type = atlasEntity.getType();
        String typeName = type.name();
        if (ItemType.RELATION.equals((Object)type) && Validators.isOfType((Taggable)atlasEntity, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.MULTIPOLYGON})) {
            tippecanoe.layer("MULTIPOLYGON");
        } else {
            tippecanoe.layer(typeName);
        }
        tippecanoe.minimumZoom(MinimumZoom.INSTANCE.get(atlasEntity.getTags()));
    };

    private TippecanoeSettings() {
    }
}

