/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.openstreetmap.atlas.utilities.scalars.Duration;

public class LocalTime {
    private static final int NANO_PER_MILLI = 1000000;
    private static final String DEFAULT_FORMAT = "yyyyMMdd-HHmmss-zzz";
    private final Duration epoch;
    private final ZoneId timeZone;
    private LocalDateTime dateTime = null;

    public static LocalTime now(ZoneId offset) {
        return new LocalTime(Duration.milliseconds(System.currentTimeMillis()), offset);
    }

    public LocalTime(Duration epoch, ZoneId timeZone) {
        this.epoch = epoch;
        this.timeZone = timeZone;
    }

    public int day() {
        return this.getDateTime().getDayOfMonth();
    }

    public Duration elapsedBetween(LocalTime time) {
        return Duration.milliseconds(Math.abs(time.epoch.asMilliseconds() - this.epoch.asMilliseconds()));
    }

    public Duration elapsedSince() {
        return Duration.milliseconds(LocalTime.now((ZoneId)this.timeZone).epoch.asMilliseconds() - this.epoch.asMilliseconds());
    }

    public String format(DateTimeFormatter formatter) {
        return formatter.format(this.getDateTime());
    }

    public String format(String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return this.getDateTime().format(formatter);
    }

    public Duration getEpoch() {
        return this.epoch;
    }

    public int hour() {
        return this.getDateTime().getHour();
    }

    public int millisecond() {
        return (int)Math.round((double)this.getDateTime().getNano() / 1000000.0);
    }

    public int minute() {
        return this.getDateTime().getMinute();
    }

    public int month() {
        return this.getDateTime().getMonthValue();
    }

    public int second() {
        return this.getDateTime().getSecond();
    }

    public String toString() {
        return this.format(DEFAULT_FORMAT);
    }

    public Duration untilNow() {
        return Duration.milliseconds(System.currentTimeMillis()).difference(this.epoch);
    }

    public int year() {
        return this.getDateTime().getYear();
    }

    private LocalDateTime getDateTime() {
        if (this.dateTime == null) {
            this.dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.epoch.asMilliseconds()), this.timeZone);
        }
        return this.dateTime;
    }
}

