/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.threads;

import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.threads.Pool;
import org.openstreetmap.atlas.utilities.threads.Ticker;

public class Result<T> {
    private final Future<T> future;
    private final Pool pool;
    private final Optional<Ticker> ticker;

    public Result(Future<T> future, Pool pool) {
        this.pool = pool;
        this.future = future;
        this.ticker = Optional.empty();
    }

    public Result(Future<T> future, Pool pool, Ticker ticker) {
        this.pool = pool;
        this.future = future;
        this.ticker = Optional.of(ticker);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.ticker.ifPresent(Ticker::close);
        return this.future.cancel(mayInterruptIfRunning);
    }

    public T get() {
        try {
            T t = this.future.get();
            return t;
        }
        catch (Exception e) {
            throw new CoreException("Could not get value from Future in {}", this.pool, e);
        }
        finally {
            this.ticker.ifPresent(Ticker::close);
        }
    }

    public T get(Duration timeout) throws TimeoutException {
        try {
            T t = this.future.get(timeout.asMilliseconds(), TimeUnit.MILLISECONDS);
            return t;
        }
        catch (TimeoutException tex) {
            throw tex;
        }
        catch (Exception e) {
            throw new CoreException("Interrupted before {} elapsed. Could not get value from Future in {}", timeout, this.pool, e);
        }
        finally {
            this.ticker.ifPresent(Ticker::close);
        }
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public boolean isDone() {
        return this.future.isDone();
    }
}

