/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.testing;

import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.builder.text.TextAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.creation.RawAtlasGenerator;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.WaySectionProcessor;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasCountrySlicer;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.streaming.compression.Decompressor;
import org.openstreetmap.atlas.streaming.resource.AbstractResource;
import org.openstreetmap.atlas.streaming.resource.ByteArrayResource;
import org.openstreetmap.atlas.streaming.resource.ClassResource;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.tags.BuildingPartTag;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.testing.CoreTestRule;
import org.openstreetmap.atlas.utilities.testing.CreationContext;
import org.openstreetmap.atlas.utilities.testing.FeatureIDGenerator;
import org.openstreetmap.atlas.utilities.testing.FieldHandler;
import org.openstreetmap.atlas.utilities.testing.OsmFileParser;
import org.openstreetmap.atlas.utilities.testing.OsmFileToPbf;
import org.openstreetmap.atlas.utilities.testing.TestAtlas;

public class TestAtlasHandler
implements FieldHandler {
    public static Atlas getAtlasFromJsomOsmResource(boolean josmFormat, AbstractResource resource, String fileName) {
        return TestAtlasHandler.getAtlasFromJsomOsmResource(josmFormat, resource, fileName, Optional.empty());
    }

    public static Atlas getAtlasFromJsomOsmResource(boolean josmFormat, AbstractResource resource, String fileName, Optional<String> iso) {
        FileSuffix.suffixFor(fileName).ifPresent(suffix -> {
            if (suffix == FileSuffix.GZIP) {
                resource.setDecompressor(Decompressor.GZIP);
            }
        });
        ByteArrayResource pbfFile = new ByteArrayResource();
        if (josmFormat) {
            StringResource osmFile = new StringResource();
            new OsmFileParser().update(resource, osmFile);
            new OsmFileToPbf().update(osmFile, pbfFile);
        } else {
            new OsmFileToPbf().update(resource, pbfFile);
        }
        return TestAtlasHandler.buildAtlasFromPbf(pbfFile, iso);
    }

    private static Atlas buildAtlasFromPbf(Resource pbfResource, Optional<String> iso) {
        AtlasLoadingOption loadingOption = AtlasLoadingOption.withNoFilter();
        if (iso.isPresent()) {
            loadingOption.setCountrySlicing(true);
            loadingOption.setCountryBoundaryMap(CountryBoundaryMap.fromBoundaryMap(Collections.singletonMap(iso.get(), MultiPolygon.MAXIMUM)));
        }
        Atlas rawAtlas = new RawAtlasGenerator(pbfResource, loadingOption, MultiPolygon.MAXIMUM).build();
        return new WaySectionProcessor(iso.isPresent() ? new RawAtlasCountrySlicer(loadingOption).slice(rawAtlas) : rawAtlas, loadingOption).run();
    }

    private static String[] mergeTags(String[] firstTags, String[] secondTags) {
        ArrayList<String> allTags = new ArrayList<String>(Arrays.asList(firstTags));
        allTags.addAll(Arrays.asList(secondTags));
        return allTags.toArray(new String[0]);
    }

    private static Map<String, String> mergeTags(Map<String, String> firstTags, Map<String, String> secondTags) {
        HashMap<String, String> returnValue = new HashMap<String, String>();
        returnValue.putAll(firstTags);
        returnValue.putAll(secondTags);
        return returnValue;
    }

    private static Map<String, String> parseTags(Optional<String> iso, String ... tags) {
        HashMap<String, String> tagmap = new HashMap<String, String>();
        for (String tagAndValue : tags) {
            StringList fullySplit = StringList.split(tagAndValue, "=");
            if (fullySplit.size() == 2) {
                tagmap.put(fullySplit.get(0), fullySplit.get(1));
                continue;
            }
            if (fullySplit.size() == 1) {
                tagmap.put(fullySplit.get(0), "");
                continue;
            }
            throw new CoreException("{} isn't a valid tag description", tagAndValue);
        }
        if (iso.isPresent() && !tagmap.containsKey("iso_country_code".toLowerCase())) {
            tagmap.put("iso_country_code".toLowerCase(), iso.get());
        }
        return tagmap;
    }

    @Override
    public void create(Field field, CoreTestRule rule, CreationContext context) {
        TestAtlas testAtlas = field.getAnnotation(TestAtlas.class);
        if (StringUtils.isNotEmpty(testAtlas.loadFromTextResource())) {
            try {
                this.loadFromTextResource(field, rule, context, testAtlas.loadFromTextResource());
            }
            catch (Throwable e) {
                throw new CoreException("Error creating field {}", field, e);
            }
        } else if (StringUtils.isNotEmpty(testAtlas.loadFromJosmOsmResource())) {
            try {
                this.loadFromJosmOsmResource(field, rule, context, testAtlas.loadFromJosmOsmResource(), true);
            }
            catch (Throwable e) {
                throw new CoreException("Error creating field {}", field, e);
            }
        } else if (StringUtils.isNotEmpty(testAtlas.loadFromOsmResource())) {
            try {
                this.loadFromJosmOsmResource(field, rule, context, testAtlas.loadFromOsmResource(), false);
            }
            catch (Throwable e) {
                throw new CoreException("Error creating field {}", field, e);
            }
        } else {
            this.createDirectly(testAtlas, field, rule, context);
        }
    }

    @Override
    public boolean handles(Field field) {
        Class<?> fieldClass = field.getType();
        return Atlas.class.isAssignableFrom(fieldClass);
    }

    private long addArea(PackedAtlasBuilder builder, FeatureIDGenerator areaIDGenerator, TestAtlas.Area area, Optional<String> iso, String ... additionalTags) {
        long areaId = areaIDGenerator.nextId(area.id());
        builder.addArea(areaId, this.buildAreaPolygon(area), TestAtlasHandler.parseTags(iso, TestAtlasHandler.mergeTags(area.tags(), additionalTags)));
        return areaId;
    }

    private Polygon buildAreaPolygon(TestAtlas.Area area) {
        if (area.known() == TestAtlas.Area.Known.USE_COORDINATES) {
            if (area.coordinates().length == 0) {
                return new Polygon((Iterable<Location>)Location.TEST_1);
            }
            return this.convertPolygon(area.coordinates());
        }
        if (area.known() == TestAtlas.Area.Known.BUILDING_1) {
            return Polygon.TEST_BUILDING;
        }
        if (area.known() == TestAtlas.Area.Known.BUILDING_2) {
            return Polygon.TEST_BUILDING_PART;
        }
        return Polygon.SILICON_VALLEY;
    }

    private Location convertLoc(TestAtlas.Loc point) {
        if (point.value().equalsIgnoreCase("<novalue>") && (point.lat() == -9.223372036854776E18 || point.lon() == -9.223372036854776E18)) {
            throw new CoreException("Loc doesn't have a valid string value or lat/lon values");
        }
        if (point.value().equalsIgnoreCase("<novalue>")) {
            return new Location(Latitude.degrees(point.lat()), Longitude.degrees(point.lon()));
        }
        if (point.value().equalsIgnoreCase("<test1>")) {
            return Location.TEST_1;
        }
        return Location.forString(point.value());
    }

    private PolyLine convertPolyLine(TestAtlas.Loc[] points) {
        return new PolyLine(this.pointsToLocations(points));
    }

    private Polygon convertPolygon(TestAtlas.Loc[] points) {
        return new Polygon(this.pointsToLocations(points));
    }

    private AtlasSize convertSizeEstimates(TestAtlas.SizeEstimate estimate) {
        return new AtlasSize(estimate.edges(), estimate.nodes(), estimate.areas(), estimate.lines(), estimate.point(), estimate.relations());
    }

    private void createDirectly(TestAtlas testAtlas, Field field, CoreTestRule rule, CreationContext context) {
        Optional<String> iso;
        PackedAtlasBuilder builder = new PackedAtlasBuilder();
        AtlasSize size = this.convertSizeEstimates(testAtlas.size());
        Optional<String> optional = iso = testAtlas.iso().equals("UNKNOWN") ? Optional.empty() : Optional.of(testAtlas.iso());
        if (iso.isPresent()) {
            AtlasMetaData metaData = new AtlasMetaData(size, true, null, null, (String)iso.get(), null, Maps.hashMap(new String[0]));
            builder.withMetaData(metaData);
        } else {
            builder.setSizeEstimates(size);
        }
        this.handle(builder, iso, testAtlas.nodes());
        this.handle(builder, iso, testAtlas.edges());
        this.handle(builder, iso, testAtlas.areas());
        this.handle(builder, iso, testAtlas.lines());
        this.handle(builder, iso, testAtlas.points());
        this.handle(builder, iso, testAtlas.relations());
        this.handle(builder, iso, testAtlas.buildings());
        try {
            field.set(rule, builder.get());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new CoreException("Error creating test atlas", e);
        }
    }

    private void handle(PackedAtlasBuilder builder, Optional<String> iso, TestAtlas.Area ... areas) {
        FeatureIDGenerator areaIDGenerator = new FeatureIDGenerator();
        for (TestAtlas.Area area : areas) {
            this.addArea(builder, areaIDGenerator, area, iso, new String[0]);
        }
    }

    private void handle(PackedAtlasBuilder builder, Optional<String> iso, TestAtlas.Building ... buildings) {
        FeatureIDGenerator buildingGenerator = new FeatureIDGenerator();
        for (TestAtlas.Building building : buildings) {
            TreeSet<Long> outerIds = new TreeSet<Long>();
            TreeSet<Long> innerIds = new TreeSet<Long>();
            TreeSet<Long> partIds = new TreeSet<Long>();
            outerIds.add(this.addArea(builder, buildingGenerator, building.outer(), iso, new String[0]));
            for (TestAtlas.Area inner : building.inners()) {
                innerIds.add(this.addArea(builder, buildingGenerator, inner, iso, new String[0]));
            }
            for (TestAtlas.Area part : building.parts()) {
                partIds.add(this.addArea(builder, buildingGenerator, part, iso, "building:part", BuildingPartTag.YES.getTagValue()));
            }
            RelationBean outline = new RelationBean();
            outline.addItem((Long)outerIds.first(), "outer", ItemType.AREA);
            for (Long innerId : innerIds) {
                outline.addItem(innerId, "inner", ItemType.AREA);
            }
            long outlineId = buildingGenerator.nextId("<auto>");
            builder.addRelation(outlineId, outlineId, outline, TestAtlasHandler.mergeTags(TestAtlasHandler.parseTags(iso, building.outlineTags()), Validators.toMap(RelationTypeTag.MULTIPOLYGON)));
            RelationBean multipart = new RelationBean();
            multipart.addItem(outlineId, "outline", ItemType.RELATION);
            for (Long partId : partIds) {
                multipart.addItem(partId, "part", ItemType.AREA);
            }
            long buildingId = buildingGenerator.nextId("<auto>");
            builder.addRelation(buildingId, buildingId, multipart, TestAtlasHandler.mergeTags(TestAtlasHandler.parseTags(iso, building.tags()), Validators.toMap(RelationTypeTag.BUILDING)));
        }
    }

    private void handle(PackedAtlasBuilder builder, Optional<String> iso, TestAtlas.Edge ... edges) {
        FeatureIDGenerator edgeIDGenerator = new FeatureIDGenerator();
        for (TestAtlas.Edge edge : edges) {
            builder.addEdge(edgeIDGenerator.nextId(edge.id()), this.convertPolyLine(edge.coordinates()), TestAtlasHandler.parseTags(iso, edge.tags()));
        }
    }

    private void handle(PackedAtlasBuilder builder, Optional<String> iso, TestAtlas.Line ... lines) {
        FeatureIDGenerator lineIDGenerator = new FeatureIDGenerator();
        for (TestAtlas.Line line : lines) {
            builder.addLine(lineIDGenerator.nextId(line.id()), this.convertPolyLine(line.coordinates()), TestAtlasHandler.parseTags(iso, line.tags()));
        }
    }

    private void handle(PackedAtlasBuilder builder, Optional<String> iso, TestAtlas.Node ... nodes) {
        FeatureIDGenerator nodeIDGenerator = new FeatureIDGenerator();
        for (TestAtlas.Node node : nodes) {
            builder.addNode(nodeIDGenerator.nextId(node.id()), this.convertLoc(node.coordinates()), TestAtlasHandler.parseTags(iso, node.tags()));
        }
    }

    private void handle(PackedAtlasBuilder builder, Optional<String> iso, TestAtlas.Point ... points) {
        FeatureIDGenerator pointIDGenerator = new FeatureIDGenerator();
        for (TestAtlas.Point point : points) {
            builder.addPoint(pointIDGenerator.nextId(point.id()), this.convertLoc(point.coordinates()), TestAtlasHandler.parseTags(iso, point.tags()));
        }
    }

    private void handle(PackedAtlasBuilder builder, Optional<String> iso, TestAtlas.Relation ... relations) {
        FeatureIDGenerator relationIDGenerator = new FeatureIDGenerator();
        for (TestAtlas.Relation relation : relations) {
            RelationBean bean = new RelationBean();
            for (TestAtlas.Relation.Member member : relation.members()) {
                bean.addItem(Long.parseLong(member.id()), member.role(), Enum.valueOf(ItemType.class, member.type().toUpperCase()));
            }
            long identifier = relationIDGenerator.nextId(relation.id());
            long osmIdentifier = relation.osmId().equals("<default>") ? identifier : relationIDGenerator.nextId(relation.osmId());
            builder.addRelation(identifier, osmIdentifier, bean, TestAtlasHandler.parseTags(iso, relation.tags()));
        }
    }

    private void loadFromJosmOsmResource(Field field, CoreTestRule rule, CreationContext context, String resourcePath, boolean josmFormat) {
        String packageName = rule.getClass().getPackage().getName().replaceAll("\\.", "/");
        String completeName = String.format("%s/%s", packageName, resourcePath);
        try {
            field.set(rule, TestAtlasHandler.getAtlasFromJsomOsmResource(josmFormat, new ClassResource(completeName), Paths.get(completeName, new String[0]).getFileName().toString(), field.getAnnotation(TestAtlas.class).iso().equals("UNKNOWN") ? Optional.empty() : Optional.of(field.getAnnotation(TestAtlas.class).iso())));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new CoreException("Error loading from JOSM osm resource {}", resourcePath, e);
        }
    }

    private void loadFromTextResource(Field field, CoreTestRule rule, CreationContext context, String resourcePath) {
        String packageName = rule.getClass().getPackage().getName().replaceAll("\\.", "/");
        String completeName = String.format("%s/%s", packageName, resourcePath);
        ClassResource resource = new ClassResource(completeName);
        FileSuffix.suffixFor(completeName).ifPresent(suffix -> {
            if (suffix == FileSuffix.GZIP) {
                resource.setDecompressor(Decompressor.GZIP);
            }
        });
        try {
            field.set(rule, new TextAtlasBuilder().read(resource));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new CoreException("Error loading from text resource {}", resourcePath, e);
        }
    }

    private List<Location> pointsToLocations(TestAtlas.Loc[] points) {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (TestAtlas.Loc point : points) {
            locations.add(this.convertLoc(point));
        }
        return locations;
    }
}

