/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.testing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class OsmFileParser {
    private final List<Tuple<String, String>> replacements = new ArrayList<Tuple<String, String>>();

    public OsmFileParser() {
        this.replacements.add(new Tuple<String, String>("id=\\'-", "id=\\'"));
        this.replacements.add(new Tuple<String, String>("ref=\\'-", "ref=\\'"));
        this.replacements.add(new Tuple<String, String>("action=\\'modify\\'", "uid=\\'1\\' version=\\'1\\' changeset=\\'1\\' user=\\'myself\\' timestamp=\\'2017-12-19T21:43:02Z\\' action=\\'modify\\'"));
        this.replacements.add(new Tuple<String, String>("generator=\\'JOSM\\'", "generator=\\'JOSM\\' timestamp=\\'2017-12-19T21:43:02Z\\'"));
    }

    public void update(Resource josmOsmFile, WritableResource osmFile) {
        StringList result = new StringList();
        Iterator<String> iterator = josmOsmFile.lines().iterator();
        while (iterator.hasNext()) {
            String line;
            String replaced = line = iterator.next();
            for (Tuple<String, String> replacement : this.replacements) {
                replaced = replaced.replaceAll(replacement.getFirst(), replacement.getSecond());
            }
            result.add(replaced);
        }
        osmFile.writeAndClose(result.join(System.lineSeparator()));
    }
}

