/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.testing;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.testing.Bean;
import org.openstreetmap.atlas.utilities.testing.CoreTestRule;
import org.openstreetmap.atlas.utilities.testing.CreationContext;
import org.openstreetmap.atlas.utilities.testing.FieldHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanHandler
implements FieldHandler {
    private static final Logger logger = LoggerFactory.getLogger(BeanHandler.class);

    @Override
    public void create(Field field, CoreTestRule rule, CreationContext context) {
        try {
            Class<?> fieldClass = field.getType();
            Optional<Constructor<?>> constructor = this.findConstructorIn(fieldClass);
            if (constructor.isPresent()) {
                Object object = constructor.get().newInstance(new Object[0]);
                Bean bean = field.getAnnotation(Bean.class);
                Arrays.asList(bean.value()).stream().map(value -> StringList.split(value, "=")).filter(list -> list.size() == 2).forEach(stringList -> {
                    Object key = stringList.get(0);
                    key = "set" + ((String)key).substring(0, 1).toUpperCase() + ((String)key).substring(1);
                    try {
                        Method method = fieldClass.getDeclaredMethod((String)key, String.class);
                        method.invoke(object, stringList.get(1));
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException oops) {
                        throw new CoreException("Couldn't call {} on {}", key, fieldClass, oops);
                    }
                });
                field.set(rule, object);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new CoreException("Unable to create rule", e);
        }
    }

    @Override
    public boolean handles(Field field) {
        return this.findConstructorIn(field.getType()).isPresent();
    }

    private Optional<Constructor<?>> findConstructorIn(Class<?> klass) {
        try {
            return Optional.of(klass.getDeclaredConstructor(new Class[0]));
        }
        catch (Exception oops) {
            logger.warn("Couldn't find default constructor", (Throwable)oops);
            return Optional.empty();
        }
    }
}

